<?php

/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class Settings_ITS4YouWHDeliveryNotes_Preferences_View extends Settings_Vtiger_Index_View
{

    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();
        unset($headerScriptInstances["modules.$moduleName.resources.Edit"]);

        $jsFileNames = array(
            'modules.Settings.ITS4YouWHDeliveryNotes.resources.Preferences',
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $viewer->assign('PREFERENCES_URL', 'index.php?parent=Settings&module=ITS4YouWHDeliveryNotes&view=Preferences');
        $qualifiedModule = $request->getModule(false);

        switch ($request->get("mode")) {
            case "edit":
                $viewer->assign("VIEWMODEL", $this->getViewModel());
                $viewer->view('PreferencesEdit.tpl', $qualifiedModule);
                break;

            case "save":
                $this->savePreferences($request);
                $viewer->assign("MESSAGE", vtranslate("LBL_PREFERENCES_SAVED", "ITS4YouWHDeliveryNotes"));
                $viewer->assign("VIEWMODEL", $this->getViewModel());
                $viewer->view('Preferences.tpl', $qualifiedModule);
                break;

            default:    // detail
                $viewer->assign("VIEWMODEL", $this->getViewModel());
                $viewer->view('Preferences.tpl', $qualifiedModule);
        }
    }

    private function getViewModel()
    {
        $preferenceInstances = ITS4YouWHDeliveryNotes_Preferences_Model::loadAll();

        return array("preferences" => $preferenceInstances);
    }

    private function savePreferences(Vtiger_Request $request)
    {
        $preferenceInstances = ITS4YouWHDeliveryNotes_Preferences_Model::loadAll();
        foreach ($preferenceInstances as $preferenceInstance) {
            /* @var $preferenceInstance ITS4YouWHDeliveryNotes_Preferences_Model */
            // commented out because of checkboxes
//            if($request->has($preferenceInstance->getName())) {
            $preferenceInstance->setEditViewValue($request->get($preferenceInstance->getName()));
            $preferenceInstance->save();
//            }
        }
    }

}
