<?php
/*********************************************************************************
 * The content of this file is subject to the FieldMapping 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * *******************************************************************************/

class Settings_ITS4YouFieldMapping_EditMapping_View extends Settings_Vtiger_Index_View
{

    /**
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $recordId = $request->get('recordId');
        $currentModule = $request->get('module');
        $parent = $request->get('parent');
        $qualifiedModule = $request->getModule(false);
        /** @var ITS4YouFieldMapping_Module_Model $moduleModel */
        $moduleModel = Vtiger_Module_Model::getInstance($currentModule);

        $fieldsId = $moduleModel->getFieldsId($recordId);

        $mappingModel = new Settings_ITS4YouFieldMapping_Module_Model();
        $InfoAboutRecord = $mappingModel->getFieldMappingInfo($recordId);

        $moduleFrom = $InfoAboutRecord['module_from'];
        $fieldsModelsModuleFrom = $moduleModel->getFieldsByModuleIdFrom($moduleFrom);
        $moduleModel->getFieldsForControl($fieldsModelsModuleFrom);

        $moduleTo = $InfoAboutRecord['module_to'];
        $moduleModelTo = Settings_LayoutEditor_Module_Model::getInstance(getTabModuleName($moduleTo));
        $fieldsModelsModuleTo = $moduleModelTo->getFields();
        $moduleModel->getFieldsForControl($fieldsModelsModuleTo);
        
        $fieldControl = $moduleModel->get('controlFields');
        $fieldControl = json_encode($fieldControl);

        $viewer = $this->getViewer($request);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModule);
        $viewer->assign('CURRENT_MODULE', $currentModule);
        $viewer->assign('PARENT', $parent);
        $viewer->assign('INFOABOUTRECORD', $InfoAboutRecord);
        $viewer->assign('FIELDSID', $fieldsId);
        $viewer->assign('MODULEFROMFIELDS', $fieldsModelsModuleFrom);
        $viewer->assign('MODULETOFIELDS', $fieldsModelsModuleTo);
        $viewer->assign('RECORDID', $recordId);
        $viewer->assign('LINKTOLIST', $moduleModel->getDefaultUrl());
        $viewer->assign('FIELDSCONTROL', $fieldControl);
        $viewer->assign('MAPPING_MODEL', $mappingModel);
        $viewer->assign('MODULE_FROM', $moduleFrom);
        $viewer->view('EditMapping.tpl', $qualifiedModule);
    }

    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.Settings.$moduleName.resources.EditMapping",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);

        return array_merge($headerScriptInstances, $jsScriptInstances);
    }
}
