<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductMovements_View extends ITS4YouWarehouses_ProductWHRelatedList_View
{

    private $listViewModel = null;

    public function checkPermission(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $recordId = $request->get('record');

        $recordPermission = Users_Privileges_Model::isPermitted($moduleName, 'DetailView', $recordId);
        if (!$recordPermission) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @return string
     */
    protected function getTitle(Vtiger_Request $request)
    {
        if (!$request->has('warehouseid')) {
            return vtranslate('LBL_MOVEMENTS', 'ITS4YouWarehouses');
        } else {
            $whRecordModel = Vtiger_Record_Model::getInstanceById($request->get('warehouseid'));

            return vtranslate('LBL_MOVEMENTS_IN_WAREHOUSE', 'ITS4YouWarehouses') . (string)$whRecordModel->get(
                    'warehouse_name'
                );
        }
    }

    /**
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     */
    protected function adjustViewer(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        parent::adjustViewer($request, $viewer);

        $listViewModel = $this->getListViewModel($request);
        $viewer->assign('LISTVIEW_OVERVIEW', $listViewModel->getProductMovementsOverview());
        if ($request->has("warehouseid")) {
            $viewer->assign("WAREHOUSEID", $request->get("warehouseid"));
        }
    }

    /**
     * @param Vtiger_Request $request
     * @return ITS4YouWarehouses_ProductMovementsListView_Model
     */
    public function getListViewModel(Vtiger_Request $request)
    {
        if ($this->listViewModel == null) {
            $this->listViewModel = new ITS4YouWarehouses_ProductMovementsListView_Model();
            $this->listViewModel->setProductId($request->get("record"));

            if ($request->has("warehouseid")) {
                $this->listViewModel->setWarehouseId($request->get("warehouseid"));
            }
        }

        return $this->listViewModel;
    }

    /**
     * @return string
     */
    protected function getAdditionalTemplateName()
    {
        return "ProductMovementsOverview.tpl";
    }

}
