<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_InRelation_View extends Vtiger_RelatedList_View
{

    public $relatedLists = [
        'ProductMovements' => 'ITS4YouWarehouses_ProductMovements_View',
        'ProductInWarehouses' => 'ITS4YouWarehouses_ProductInWarehouses_View',
    ];

    /**
     * @param Vtiger_Request $request
     * @return void
     * @throws AppException
     */
    public function process(Vtiger_Request $request)
    {
        $tabLabel = $request->get('tab_label');

        if (isset($this->relatedLists[$tabLabel]) && !empty($this->relatedLists[$tabLabel])) {
            $process = new $this->relatedLists[$tabLabel]();

            if ($process->checkPermission($request)) {
                $process->process($request);
            }
        } else {
            return parent::process($request);
        }
    }
}