<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

abstract class ITS4YouWarehouses_StatusPoolBase_Sequential
{
    /* @var $instance ITS4YouWarehouses_DNStatusPool_Sequential */

    protected $statuses = array();

    /**
     * ITS4YouWarehouses_StatusPoolBase_Sequential constructor.
     * @param string $_statusColumnName
     * @throws Exception
     */
    protected function __construct($_statusColumnName)
    {
        $this->initStatuses($_statusColumnName);
    }

    /**
     * @param string $_statusColumnName
     * @throws Exception
     */
    protected function initStatuses($_statusColumnName)
    {
        $adb = PearDatabase::getInstance();
        $sql = "SELECT DISTINCT " . $_statusColumnName . " FROM vtiger_" . $_statusColumnName . " WHERE presence = 1 ORDER BY sortorderid";
        $result = $adb->query($sql);

        if ($adb->num_rows($result) <= 0) {
            throw new Exception("MultiWarehouses4You :: No table for sequential statuses found.");
        }

        /**
         * @var $prevStatusInstance ITS4YouWarehouses_IStatus_Sequential
         * @var $statusInstance ITS4YouWarehouses_IStatus_Sequential
         */
        $prevStatusInstance = $statusInstance = null;
        while ($row = $adb->fetchByAssoc($result)) {
            $statusId = $row[$_statusColumnName];
            $statusInstance = new ITS4YouWarehouses_Status_Sequential($statusId);
            $statusInstance->setPrev($prevStatusInstance);

            if ($prevStatusInstance != null) {
                $prevStatusInstance->setNext($statusInstance);
            }

            $prevStatusInstance = $statusInstance;
            $this->statuses[$statusId] = $statusInstance;
        }
        if ($statusInstance != null) {
            $statusInstance->setNext(null);
        }
    }

    /**
     * @param string $_statusId
     * @return ITS4YouWarehouses_IStatus_Sequential
     */
    public function getStatusInstance($_statusId)
    {
        if (isset($this->statuses[$_statusId])) {
            return $this->statuses[$_statusId];
        } else {
            return null;
        }
    }

    public function getFirst()
    {
        return reset($this->statuses);
    }

}
