<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_Status_Sequential implements ITS4YouWarehouses_IStatus_Sequential
{

    /** @var string */
    private $id;

    /** @var ITS4YouWarehouses_Status_Sequential */
    private $successor;

    /** @var ITS4YouWarehouses_Status_Sequential */
    private $predecessor;

    /**
     * @param string $_id
     */
    public function __construct($_id)
    {
        $this->id = $_id;
    }

    /**
     * @return ITS4YouWarehouses_IStatus_Sequential
     */
    public function getNext()
    {
        return $this->successor;
    }

    /**
     * @return ITS4YouWarehouses_IStatus_Sequential
     */
    public function getPrev()
    {
        return $this->predecessor;
    }

    /**
     * @param ITS4YouWarehouses_IStatus_Sequential $_successor
     */
    public function setNext($_successor)
    {
        $this->successor = $_successor;
    }

    /**
     * @param ITS4YouWarehouses_IStatus_Sequential $_predecessor
     */
    public function setPrev($_predecessor)
    {
        $this->predecessor = $_predecessor;
    }

    public function toString()
    {
        $nextId = $this->successor != null ? $this->successor->getId() : "NULL";
        $prevId = $this->predecessor != null ? $this->predecessor->getId() : "NULL";
        $id = $this->id;

        return implode(" - ", array($id, $nextId, $prevId));
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

}
