/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */
/** @var ITS4YouUtils_Js*/

jQuery.Class('ITS4YouUtils_Js', {
	instance: false,
	getInstance: function () {
		if (!this.instance) {
			this.instance = new ITS4YouUtils_Js();
		}

		return this.instance
	},
	recalculateQuantities: function (productId) {
		const params = {
			module: 'ITS4YouWarehouses',
			view: 'JsUtilsHandler',
			mode: 'recalculate',
		};

		if (typeof productId != 'undefined') {
			params['productId'] = productId;
		}

		app.request.post({data: params}).then(function (error, data) {
			if(!error) {
				app.helper.showSuccessNotification({message: data})
			} else {
				app.helper.showSuccessNotification({message: error})
			}

			jQuery('[data-trigger="relatedListSearch"]').trigger('click');
		});
	},
	recalculateWarehouses: function (warehouseId) {
		let params = {
			module: 'ITS4YouWarehouses',
			view: 'JsUtilsHandler',
			mode: 'recalculate',
		};

		if (typeof warehouseId != 'undefined') {
			params['warehouseId'] = warehouseId;
		}

		app.request.post({data: params}).then(function (error, data) {
			if (!error) {
				app.helper.showSuccessNotification({message: data});
			}
		});
	},
	returnProducts: function (moduleName, recordId, urlParams) {
		if ('undefined' == typeof urlParams) {
			urlParams = '';
		}

		let url = 'index.php?module=ITS4YouWarehouses&view=JsUtilsHandler&mode=returnProducts&sourceModule=' + moduleName + '&sourceRecord=' + recordId + urlParams;

		ITS4YouUtils_Js.showActionModal(url, function () {
			const formInstance = jQuery('form#ReturnProductsActionForm');
			//if everything was already returned then display message

			if (false === formInstance.data('its4you-isreturnable')) {
				app.helper.showAlertNotification({message: app.vtranslate('ALERT_ALL_RETURNED')});
			} else {
				formInstance.vtValidate();
				formInstance.submit(function () {
					let allZero = true;

					jQuery(this).find('input.qty').each(function () {
						if (jQuery(this).val() > 0) {
							allZero = false;
						}
					});

					if (allZero) {
						app.helper.showErrorNotification({message: app.vtranslate('ALERT_CANNOT_RETURN_ZERO')});
						return false;
					}

					return true;
				});
			}
		});
	},
	showActionModal: function (url, callback, unblockCallback) {

		app.request.post({url: url}).then(function (error, data) {
			app.helper.showModal(data, {cb: callback});
		});
	},
}, {
	updateTotalPageCount: function () {
		const pageCount = parseInt(jQuery('#pageCount').val()),
			relatedLinks = jQuery('[data-url*="ProductMovements"], [data-url*="ProductInWarehouses"]');

		if (pageCount) {
			jQuery('#totalPageCount').text(pageCount);
		}

		relatedLinks.find('.numberCircle').addClass('hide');
		relatedLinks.find('.tab-icon').css({
			'max-width': '100%',
		});
	},
	registerUpdateTotalPageCount: function () {
		const self = this;

		jQuery(document).ajaxComplete(function () {
			self.updateTotalPageCount();
		});
	},
	registerEvents: function () {
		this.registerUpdateTotalPageCount();
	},
});

/** @var ITS4YouUtils_Edit_js*/

jQuery.Class('ITS4YouUtils_Edit_js', {
	instance: false,
	getInstance: function () {
		if (!this.instance) {
			this.instance = new ITS4YouUtils_Edit_js();
		}

		return this.instance;
	}
}, {
	quantities: [],
	warehouseField: 'warehouseid',
	negativeQty: false,
	setQuantity: function (warehouseId, productId, quantity) {
		this.quantities[warehouseId + 'x' + productId] = quantity;
	},
	getQuantity: function (warehouseId, productId) {
		return this.quantities[warehouseId + 'x' + productId];
	},
	isNegativeQuantity: function (warehouseId, productId, parentRow) {
		let self = this,
			subProducts = parentRow.find('[name*="subproduct_ids"]').val(),
			quantity = parentRow.find('[name*="qty"]').val(),
			result = false;

		if (!subProducts) {
			return (self.getQuantity(warehouseId, productId) - self.getItemsQuantity(warehouseId, productId)) < 0
		} else {
			let productQuantities = self.getSubProductQuantities(parentRow);

			$.each(productQuantities, function (subProductId, subProductQty) {
				if ((self.getQuantity(warehouseId, subProductId) - self.getItemsQuantity(warehouseId, subProductId)) < 0) {
					result = true;
				}
			});
		}

		return result;
	},
	getSubProductQuantities: function (row) {
		let products = [],
			subProducts = row.find('[name*="subproduct_ids"]').val();

		$.each(subProducts.split(','), function (index, productQty) {
			let data = productQty.split(':');

			products[data[0]] = parseFloat(data[1]);
		});

		return products;
	},
	getItemsQuantity: function(warehouseId, productId) {
		let self = this,
			quantity = 0;

		$('.lineItemRow').each(function() {
			let row = $(this),
				subProducts = self.getSubProductQuantities(row),
				product = row.find('[name*="hdnProductId"]').val(),
				productQty = parseFloat(row.find('[name*="qty"]').val());

			if (product === productId) {
				quantity += productQty;
			}

			if (subProducts[productId]) {
				quantity += productQty * subProducts[productId];
			}
		});

		return quantity;
	},
	/**
	 * @param warehouseId
	 * @param productId
	 * @param parentRow
	 * @returns {*}
	 */
	setQtyInStock: function (warehouseId, productId, parentRow) {
		const self = this,
			aDeferred = jQuery.Deferred();

		if (warehouseId && productId) {
			const params = {
				module: 'ITS4YouWarehouses',
				action: 'GetQtyInStock',
				record: warehouseId,
				productid: productId,
				sourceRecord: $('[name="record"]').val(),
			};

			app.request.post({data: params}).then(function (error, data) {
				if (!error) {
					if('object' === typeof data) {
						$.each(data, function(product, quantity) {
							self.setQuantity(warehouseId, product, quantity);
						});
					}

					let quantityInStock = self.getQuantity(warehouseId, productId);

					parentRow.data('quantity-in-stock', quantityInStock);
					parentRow.find('.qtyInStock, .maxQuantity').text(app.convertCurrencyToUserFormat(quantityInStock));

					if (self.isNegativeQuantity(warehouseId, productId, parentRow)) {
						parentRow.find('.stockAlert').removeClass('hide');
					} else {
						parentRow.find('.stockAlert').addClass('hide');
					}

					aDeferred.resolve();
				}
			});
		} else {
			parentRow.find('.stockAlert').addClass('hide');
		}

		return aDeferred.promise();
	},
	/**
	 * @returns {jQuery|null|[]|string|*|undefined}
	 */
	getWarehouseId: function () {
		return this.getForm().find('input[name="' + this.warehouseField + '"]').val();
	},
	/**
	 * @param row
	 * @returns {jQuery|null|[]|string|*|undefined}
	 */
	getProductId: function (row) {
		return jQuery(row).find('.selectedModuleId').val();
	},
	/**
	 * @returns {jQuery|HTMLElement}
	 */
	getForm: function () {
		return jQuery('#EditView');
	},
	/**
	 * @returns {jQuery|HTMLElement}
	 */
	getLineItemContainer: function () {
		return jQuery('#lineItemTab');
	},
	registerWarehouseChange: function () {
		const self = this;

		this.getForm().on(Vtiger_Edit_Js.referenceSelectionEvent, 'input[name="' + this.warehouseField + '"]', function () {
			self.getLineItemContainer().find('.lineItemRow').each(function () {
				const row = jQuery(this);

				self.setQtyInStock(self.getWarehouseId(), self.getProductId(row), row);
				self.setNegativeQty();
			})
		});
	},
	registerProductChange: function () {
		const self = this;

		this.getLineItemContainer().on('focusout', '.qty', function () {
			const row = jQuery(this).parents('tr');

			self.setQtyInStock(self.getWarehouseId(), self.getProductId(row), row);
		});
	},
	setNegativeQty: function () {
		const self = this,
			warehouseId = self.getWarehouseId();

		if (warehouseId) {
			const params = {
				module: 'ITS4YouWarehouses',
				action: 'IsNegativeStockEnabled',
				records: warehouseId
			};

			app.request.post({data: params}).then(function (error, data) {
				if (!error) {
					if ('1' === data['checkResults'][warehouseId]) {
						self.negativeQty = true;
					} else {
						self.negativeQty = false;
					}
				}
			});
		}
	},
	registerNegativeQty: function () {
		const self = this;

		app.event.on(Vtiger_Edit_Js.recordPresaveEvent, function (e) {
			if (!self.negativeQty && jQuery('.stockAlert:visible').length) {
				app.helper.showErrorNotification({message: app.vtranslate('ALERT_NEGATIVE_QUANTITY')});

				e.preventDefault();
			}
		});
	},
	registerEvents: function () {
		this.registerWarehouseChange();
		this.registerProductChange();
		this.registerNegativeQty();
	},
});

jQuery(function () {
	const view = app.getViewName(),
		module = app.getModuleName();

	if ('Detail' === view && 'Products' === module) {
		ITS4YouUtils_Js.getInstance().registerEvents();
	}
});