/*********************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */
/** @var ITS4YouSeqStatusHandler_Js*/

jQuery.Class('ITS4YouSeqStatusHandler_Js', {
    displayNotifyMsg: function () {
        let hash = document.location.hash.substr(1),
            alertData = false;

        if (hash) {
            alertData = hash.split('|');

            if (alertData.length) {
                let message = '';

                jQuery.each(alertData, function (index, value) {
                    message += app.vtranslate(value) + ' ';
                });

                app.helper.showSuccessNotification({
                    message: message,
                    title : app.vtranslate('Info'),
                    icon : 'fa fa-info-circle',
                }, {
                    type: 'info',
                    delay: 5000,
                    mouse_over: 'pause',
                });
                jQuery('.notificationHeader .fa-info-circle, .notificationHeader [data-notify="title"]').css({
                    color: '#08c'
                })
                document.location.hash = '';
            }
        }
    },
    showActionModal: function (url, callback, unblockCallback) {
        let msgParams = {};

        app.request.post({url: url}).then(function (error, data) {
            if (!error) {
                app.helper.showModal(data, {cb: callback});
            }
        });
    },
    registerDetailViewEvents: function (seqStatusHandlerParams) {
        const self = this;
        //registering ajax-based actions for status change (i.e. Cancel)
        jQuery('.actioncancel').on('click', function () {
            let url = 'index.php?module=ITS4YouWHDeliveryNotes&view=SeqStatusActionHandler&mode=changeStatusCancel&sourceRecord=' + jQuery('#recordId').val() + '&sourceModule=' + app.getModuleName();

            ITS4YouSeqStatusHandler_Js.showActionModal(url, function () {
                jQuery('form#ChangeStatusCancelActionForm').vtValidate();
            });
        });
        jQuery('.actiondeliver').on('click', function () {
            let url = 'index.php?module=ITS4YouWHDeliveryNotes&view=SeqStatusActionHandler&mode=changeStatusDeliver&sourceRecord=' + jQuery('#recordId').val() + '&sourceModule=' + app.getModuleName();

            ITS4YouSeqStatusHandler_Js.showActionModal(url, function () {
                jQuery('form#ChangeStatusDeliverActionForm').vtValidate();
            });
        });
        jQuery('.actionready2deliver').on('click', function () {
            window.location.href = 'index.php?module=ITS4YouWHDeliveryNotes&view=SeqStatusActionHandler&mode=changeStatus&statusMode=ready2deliver&sourceRecord=' + jQuery('#recordId').val() + '&sourceModule=' + app.getModuleName();
        });

        //disable actions for specific statuses
        let currentStatus = jQuery('ul#its4you_seq_status li.active').data('its4you-value'),
            isAdmin = jQuery('ul#its4you_seq_status').data('its4you-isadmin'),
            disableStatusIndex = jQuery.inArray(currentStatus, seqStatusHandlerParams.disableStatuses);

        if (-1 < disableStatusIndex) {
            //overriding delete record link
            jQuery(seqStatusHandlerParams.deleteLinkId).on('click', function (e) {
                e.preventDefault();
                let messages = seqStatusHandlerParams.deleteAlerts[currentStatus];

                if (1 === isAdmin) {
                    let hrefArr = jQuery(this).attr('href').split('"'),
                        deleteRecordActionUrl = hrefArr[1];

                    app.helper.showConfirmationBox({'message': app.vtranslate(messages[0])}).then(function () {
                        app.request.post({url: deleteRecordActionUrl + '&ajaxDelete=true'}).then(function (error, data) {
                            if (!error) {
                                window.location.href = data;
                            } else {
                                app.helper.showErrorNotification({message: data.error.message});
                            }
                        });
                    });
                } else {
                    app.helper.showErrorNotification({message: app.vtranslate(messages[1])});
                }
            });
            //overriding edit button
            let onClick = jQuery(seqStatusHandlerParams.editLinkId).attr('onclick');

            jQuery(seqStatusHandlerParams.editLinkId).attr('onclick', '');
            jQuery(seqStatusHandlerParams.editLinkId).on('click', function (e) {
                let messages = seqStatusHandlerParams.editAlerts[currentStatus];

                if (1 === isAdmin) {
                    app.helper.showConfirmationBox({message: app.vtranslate(messages[0])}).then(function () {
                        eval(onClick);
                    });
                } else {
                    app.helper.showErrorNotification({message: app.vtranslate(messages[1])});
                }
            });

            self.registerEditViewAjaxEdit();

            app.event.on('post.relatedListLoad.click', function () {
                self.registerEditViewAjaxEdit();
            });
        }
    },
    registerEditViewAjaxEdit: function () {
        //disabling ajax edit functionality
        let detailContentsHolder = Vtiger_Detail_Js.getInstance().getContentHolder(),
            tdFieldValues = detailContentsHolder.find('.detailview-table, .recordDetails');

        tdFieldValues.find('td.fieldValue .action').remove();
    },
    listInstance: false,
    getListInstance: function () {
        if (!this.listInstance) {
            this.listInstance = new Vtiger_List_Js();
        }

        return this.listInstance;
    },
    registerListViewEdit: function (seqStatusHandlerParams) {
        const self = this;

        jQuery('#page').on('click', 'a[name="editlink"]', function (e) {
            e.preventDefault();

            const params = {
                module: 'ITS4YouWHDeliveryNotes',
                view: 'SeqStatusActionHandler',
                mode: 'getStatus',
                sourceModule: app.getModuleName(),
                sourceRecord: jQuery(this).data('id'),
            };

            app.request.post({data: params}).then(function (error, data) {
                if (!error) {
                    let status = data.status,
                        msgKey = seqStatusHandlerParams.editAlerts[status];

                    if (!msgKey) {
                        let element = jQuery(e.currentTarget),
                            url = element.data('url'),
                            postData = self.getListInstance().getDefaultParams();

                        for (let key in postData) {
                            if (postData[key]) {
                                postData['return' + key] = postData[key];
                            }

                            delete postData[key];
                        }
                        window.location.href = url + '&' + $.param(postData);
                    } else {
                        app.helper.showAlertNotification({message: app.vtranslate(msgKey)});
                    }
                }
            });
        });
    },
    registerListViewDelete: function (recordId, extraParams, deleteAlerts) {
        if (recordId) {
            let self = this,
                url = 'index.php?module=ITS4YouWHDeliveryNotes&view=SeqStatusActionHandler&mode=getStatus&sourceModule=' + app.getModuleName() + '&sourceRecord=' + recordId;

            app.request.post({url: url}).then(function (error, data) {
                if (!error) {
                    let msgKey = deleteAlerts[data['status']];

                    if (msgKey) {
                        app.helper.showAlertNotification({message: app.vtranslate(msgKey)});
                    } else {
                        self.getListInstance().deleteRecord(recordId, extraParams);
                    }
                }
            });
        }
    },
    registerListViewMassDelete: function (url, message) {
        this.getListInstance().performMassDeleteRecords(url);

        app.event.one('post.listViewFilter.click', jQuery('.searchRow'), function () {
            app.helper.showAlertNotification({message: app.vtranslate(message)});
        });
    },
    registerListViewMassEdit: function (event, form_original_data, isOwnerChanged, message) {
        this.getListInstance().saveMassedit(event, form_original_data, isOwnerChanged);

        app.event.one('post.listViewMassEditSave', function () {
            app.helper.showAlertNotification({message: app.vtranslate(message)});
        });
    }
}, {});