/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */
/** @var ITS4YouActionBlockUtils_Js */

jQuery.Class("ITS4YouActionBlockUtils_Js", {
	instance: false,
	getInstance: function () {
		if (!ITS4YouActionBlockUtils_Js.instance) {
			ITS4YouActionBlockUtils_Js.instance = new ITS4YouActionBlockUtils_Js();
		}

		return ITS4YouActionBlockUtils_Js.instance;
	}

}, {
	languageString: [],
	overviewEventTarget: undefined,
	/**
	 * Function returns translated string based on ITS4YouWHDeliveryNotes module
	 */
	vtranslate: function (key) {
		if (this.languageString[key]) {
			return this.languageString[key];
		} else {
			let strings = jQuery('#js_strings_its4you').text();

			if (strings) {
				this.languageString = JSON.parse(strings);

				if (key in this.languageString) {
					return this.languageString[key];
				}
			}
		}
		return key;
	},
	registerEvents: function (viewName) {
		if ('Detail' === viewName) {
			this.registerDetailViewEvents();
		}
	},
	registerDetailViewEvents: function () {
		const self = this;

		self.registerActionButtons();

		jQuery('.actionAvailable').on('click', function (e) {
			let params = self.getActionParams(e);
			self.getActionHandler('available', params[0], params[1], params[2], false);
		});
		jQuery('.actionAvailableExist').on('click', function (e) {
			let params = self.getActionParams(e);
			self.getActionHandler('availableExist', params[0], params[1], params[2], true);
		});
		jQuery('.actionNotAvailable').on('click', function (e) {
			let params = self.getActionParams(e);
			self.getActionHandler('notAvailable', params[0], params[1], params[2]);
		});
		jQuery('.actionIssued').on('click', function (e) {
			let params = self.getActionParams(e);
			self.getActionHandler('issued', params[0], params[1], params[2]);
		});
		jQuery('.actionToBeInvoiced').on('click', function (e) {
			let params = self.getActionParams(e);
			self.getActionHandler('toBeInvoiced', params[0], params[1], params[2]);
		});
		jQuery('.actionAwaiting').on('click', function (e) {
			let params = self.getActionParams(e);
			self.getActionHandler('awaiting', params[0], params[1], params[2]);
		});
		jQuery('.actionShowOverview').on('click', function (e) {
			if (jQuery(e.currentTarget).is('a')) {
				//displaying overview DIV only with status-specific products - this property will be considered inside actionShowOverview
				self.overviewEventTarget = e;
			} else {
				//displaying overview DIV only with all products - this property will be considered inside actionShowOverview
				self.overviewEventTarget = undefined;
			}
			self.actionShowOverview();
		});
		jQuery('.actionIssuedInInvoice').on('click', function (e) {
			app.helper.showErrorNotification({message: self.vtranslate('ALERT_ALREADY_DELIVERED2')});
		});
		jQuery('.actionInvoiced').on('click', function (e) {
			app.helper.showErrorNotification({message: self.vtranslate('ALERT_ALREADY_INVOICED')});
		});
		jQuery('.actionReceipted').on('click', function (e) {
			app.helper.showErrorNotification({message: self.vtranslate('ALERT_ALREADY_RECEIPTED')});
		});
	},
	actionShowOverview: function () {
		let self = this,
			params = self.getActionParams(self.overviewEventTarget),
			url = 'index.php?module=ITS4YouWHDeliveryNotes&view=ActionBlockActionHandler&mode=showOverview&sourceRecord=' + params[1] + '&sourceModule=' + params[2] + '&products=' + params[0];

		self.showActionModal(url, 'overview');
	},
	registerActionButtons: function () {
		let self = this;

		jQuery('.actionAvailableButton').off('click').on('click', function (e) {
			let params = self.getActionParams(),
				message = self.vtranslate('CONFIRM_MERGE_PRODUCTS');
			//check if there are same products
			self.checkDuplicateProducts().then(function (data) {
				if (data['duplicatesExist']) {
					app.helper.showConfirmationBox({'message': message}).then(function () {
						self.getActionHandler('available', params[0], params[1], params[2], '&mergeProducts=true');
					}, function () {
						self.getActionHandler('available', params[0], params[1], params[2], '&mergeProducts=false');
					});
				} else {
					self.getActionHandler('available', params[0], params[1], params[2], '&mergeProducts=true');
				}
			});
		});

		jQuery('.actionAvailableExistButton').off('click').on('click', function (e) {
			let params = self.getActionParams(),
				message = self.vtranslate('CONFIRM_MERGE_PRODUCTS');

			self.checkDuplicateProducts().done(function (data) {
				if (data['duplicatesExist']) {
					app.helper.showConfirmationBox({'message': message}).then(function () {
						self.getActionHandler('availableExist', params[0], params[1], params[2], '&mergeProducts=true');
					}, function () {
						self.getActionHandler('availableExist', params[0], params[1], params[2], '&mergeProducts=false');
					});
				} else {
					self.getActionHandler('availableExist', params[0], params[1], params[2], '&mergeProducts=true');
				}
			});
		});

		jQuery('.actionNotAvailableButton').off('click').on('click', function (e) {
			let params = self.getActionParams();
			self.getActionHandler('notAvailable', params[0], params[1], params[2]);
		});

		jQuery('.actionIssuedButton').off('click').on('click', function (e) {
			let params = self.getActionParams();
			self.getActionHandler('issued', params[0], params[1], params[2]);
		});

		jQuery('.actionToBeInvoicedButton').off('click').on('click', function (e) {
			let params = self.getActionParams();
			self.getActionHandler('toBeInvoiced', params[0], params[1], params[2]);
		});

		jQuery('.actionAwaitingButton').off('click').on('click', function (e) {
			let params = self.getActionParams();
			self.getActionHandler('awaiting', params[0], params[1], params[2]);
		});
	},
	checkDuplicateProducts: function () {
		let self = this,
			aDeferred = jQuery.Deferred(),
			params = self.getActionParams(),
			url = 'index.php?module=ITS4YouWHDeliveryNotes&action=CheckAvailableDuplicates&products=' + params[0] + '&sourceRecord=' + params[1] + '&sourceModule=' + params[2];

		app.request.post({url: url}).then(function (error, data) {
			if (!error) {
				aDeferred.resolve(data);
			} else {
				aDeferred.reject(data);
			}
		});

		return aDeferred.promise();
	},
	getActionParams: function (e) {
		let abForm = jQuery('form#actionBlockBaseForm'),
			sourceRecord = abForm.find('input[name="sourceRecord"]').val(),
			sourceModule = abForm.find('input[name="sourceModule"]').val(),
			itemIds = [];

		if ('undefined' == typeof e) {
			//button as a trigger
			//new version because of status grouping in side widget action block
			abForm.find('input[name="items[]"]').each(function () {
				if (-1 === jQuery.inArray(jQuery(this).val(), itemIds)) {
					itemIds.push(jQuery(this).val());
				}
			});
		} else {
			//individual item as a trigger
			//new version because of status grouping in side widget action block
			let statusId = jQuery(e.currentTarget).data('its4youStatusid');
			abForm.find('input[name="items[]"]').each(function (index, element) {
				if (jQuery(element).data('its4youStatusid') === statusId) {
					itemIds.push(jQuery(this).val());
				}
			});
		}

		return [itemIds.join(';'), sourceRecord, sourceModule];
	},
	runCallbackByMode: function (mode) {
		const self = this;

		if (mode === 'available') {
			self.registerActionAvailableDivEvents();
		} else if (mode === 'issued') {
			self.registerActionIssuedInvoiceDivEvents();
			self.registerActionIssuedDivEvents();
		} else if (mode === 'toBeInvoiced') {
			self.registerActionIssuedInvoiceDivEvents();
		} else if (mode === 'awaiting') {
			self.registerActionAwaitingDivEvents();
		} else if (mode === 'notAvailable') {
			self.registerActionNotAvailableDivEvents();
		} else if (mode === 'overview') {
			self.registerActionButtons();
		} else if (self[mode]) {
			self[mode]();
		}
	},
	getActionHandler: function (mode, productIds, sourceRecord, sourceModule, addition) {
		let self = this,
			addUrl = '';

		if ('available' === mode) {
			addUrl = '&add=' + false;
		} else if ('availableExist' === mode) {
			mode = 'available';
			addUrl = '&add=' + true;
		}

		if (undefined !== addition) {
			addUrl += addition;
		}

		let url = 'index.php?module=ITS4YouWHDeliveryNotes&view=ActionBlockActionHandler&mode=' + mode + '&sourceRecord=' + sourceRecord + '&sourceModule=' + sourceModule + '&products=' + productIds + addUrl;

		self.showActionModal(url, mode);
	},
	showActionModal: function (url, callback) {
		const self = this;

		app.request.post({url: url}).then(function (error, data) {
			if (!error) {
				const modal = jQuery('.myModal');

				if (modal.is('.in')) {
					modal.find('.modal-dialog').replaceWith(data);
					self.runCallbackByMode(callback);

					vtUtils.applyFieldElementsView(modal.find('.modal-dialog'));
				} else {
					app.helper.showModal(data, {
						cb: function () {
							self.runCallbackByMode(callback);
						}
					});
				}
			} else {
				app.helper.showErrorNotification({message: error.message});
			}
		});
	},
	registerActionAvailableDivEvents: function () {
		//remove link
		jQuery('.removeItemFromActionBlockDiv').on('click', function (e) {
			jQuery(this).parents('tr').remove();
		});

		jQuery('form#IssueActionForm').vtValidate();
	},
	registerActionIssuedInvoiceDivEvents: function () {
		let dnCheckBoxes = jQuery('input[name="deliveryNoteIDs[]"]'),
			handleButton = function () {
				let checkedCount = 0;
				dnCheckBoxes.each(function () {
					if ('checked' === jQuery(this).attr('checked')) {
						checkedCount++;
					}
				});
				if (checkedCount > 0) {
					jQuery('form#DeliverInvoiceActionForm .btn-success').removeAttr('disabled');
				} else {
					jQuery('form#DeliverInvoiceActionForm .btn-success').attr('disabled', 'disabled');
				}
			};

		jQuery('input#selectAllDN').on('click', function () {
			if ('checked' === jQuery(this).attr('checked')) {
				dnCheckBoxes.attr('checked', 'checked');
			} else {
				dnCheckBoxes.removeAttr('checked');
			}
			handleButton();
		});

		dnCheckBoxes.on('click', function () {
			if ('checked' !== jQuery(this).attr('checked') && 'checked' === jQuery('input#selectAllDN').attr('checked')) {
				jQuery('input#selectAllDN').removeAttr('checked');
			}
			handleButton();
		});

		//set modal header background-color to the same value as main header has
		let bgColor = jQuery('#nav-inner').css('background-color'),
			color = jQuery('a[id^=menubar_item_]').css('color');

		jQuery('tr#massHeader th').css({
			'background-color': bgColor,
			'color': color,
		});
	},
	registerActionIssuedDivEvents: function () {
		this.registerFormOnAjaxSubmit(jQuery('form#DeliverInvoiceActionForm'));
	},
	registerActionAwaitingDivEvents: function () {
		const self = this;
		//remove link
		jQuery('.removeItemFromActionBlockDiv').on('click', function (e) {
			jQuery(this).parents('tr').remove();
		});
		const form = jQuery('form#AwaitingActionForm');

		form.vtValidate();
		//submiting via ajax
		self.registerFormOnAjaxSubmit(form);
	},
	registerActionNotAvailableDivEvents: function () {
		const self = this;
		//remove link
		jQuery('.removeItemFromActionBlockDiv').on('click', function () {
			jQuery(this).parents('tr').remove();
			self.calculateTotalOrderedPrice();
		});
		//validation
		let formElm = jQuery('form#NotAvailableActionForm');

		formElm.vtValidate();
		//submiting via ajax
		self.registerFormOnAjaxSubmit(formElm);
		//recalculation of Total Ordered price within the DIV's table
		self.registerTotalOrderedPriceCalc();
	},
	registerTotalOrderedPriceCalc: function () {
		const self = this;
		//call calculation for first display
		self.calculateTotalOrderedPrice();

		jQuery('.inputPrice, .inputQty').on('focusout', function () {
			self.calculateTotalOrderedPrice();
		});
	},
	calculateTotalOrderedPrice: function () {
		let total = 0;
		jQuery('form#NotAvailableActionForm').find('.listViewEntries').each(function () {
			let row = jQuery(this),
				qty = parseFloat(row.find('.qty').val()),
				price = parseFloat(row.find('.price').val());

			total += qty * price;
		});
		let totalOrdered = jQuery('#totalOrderedPrice'),
			numberOfDecimal = parseInt(totalOrdered.data('number-dec'));

		totalOrdered.text(total.toFixed(numberOfDecimal));
	},
	serializeMultiForm: function (form) {
		let array = form.serializeArray(),
			values = {};

		jQuery.each(array, function () {
			let name = this.name,
				value = this.value;

			if (values[name]) {
				let old_value = values[name];

				if ('string' == typeof old_value) {
					old_value = [old_value];
				}

				old_value.push(value);

				values[name] = old_value;
			} else {
				values[name] = value;
			}
		});

		return values;
	},
	registerFormOnAjaxSubmit: function (formInstance) {
		const self = this;

		formInstance.vtValidate({
			submitHandler: function () {
				let params = self.serializeMultiForm(formInstance);

				app.request.post({data: params}).then(function (error, data) {
					app.helper.hideModal();

					if (!error) {
						if (data.url) {
							document.location.href = data.url;
						} else {
							app.helper.showAlertNotification({message: data});
							ITS4YouWHDeliveryNotes_SummaryWidgets_Js.getInstance().loadWidgetBlock();
						}
					} else {
						app.helper.showErrorNotification({message: error.message});
					}
				});
			}
		});
	},
});

jQuery(document).ready(function () {
	let moduleName = app.getModuleName(),
		viewName = app.getViewName(),
		allowedModuleNames = ['SalesOrder', 'ITS4YouWHDeliveryNotes', 'Invoice', 'PurchaseOrder'];

	if (jQuery.inArray(moduleName, allowedModuleNames, 0) > -1) {
		ITS4YouActionBlockUtils_Js.getInstance().registerEvents(viewName);
	}
});