<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of WarehouseWithProductListView
 *
 * @author zavad
 */
class ITS4YouWarehouses_WarehouseWithProductListView_Model extends ITS4YouWarehouses_ListView_Model
{

    public function getQuery()
    {
        $queryGenerator = $this->get('query_generator');
        $listQuery = $queryGenerator->getQuery();

        if ($this->has("productId")) {
            $listQuery = strtolower($listQuery);

            //replace dummy its4you_warehouses.qtyinstock with the relevant one from table its4you_warehouses_productrel        
            $pattern = "/its4you_warehouses.qtyinstock/";
            $replacement = "CASE WHEN its4you_warehouses_productrel.quantity != '' THEN its4you_warehouses_productrel.quantity ELSE 0 END AS qtyinstock";
            $listQuery = preg_replace($pattern, $replacement, $listQuery, 1);

            //replace others occurecences of its4you_warehouses.qtyinstock for possible searching
            //replace dummy its4you_warehouses.qtyinstock with the relevant one from table its4you_warehouses_productrel        
            $pattern = "/its4you_warehouses.qtyinstock/";
            $replacement = "its4you_warehouses_productrel.quantity";
            $listQuery = preg_replace($pattern, $replacement, $listQuery);

            //add left join to its4you_warehouses_productrel table            
            $pattern = "/from its4you_warehouses/";
            $replacement = "from its4you_warehouses LEFT JOIN its4you_warehouses_productrel ON its4you_warehouses.warehouseid = its4you_warehouses_productrel.warehouseid 
                                                AND its4you_warehouses_productrel.productid = " . $this->get("productId");
            $listQuery = preg_replace($pattern, $replacement, $listQuery, 1);

            //adjust where condition so only warehouses which contain the product are selected 
            //or warehouses which have negative quantity allowed are selected
            $listQuery .= " AND ( its4you_warehouses_productrel.quantity > 0 OR its4you_warehouses.negative_qty = '1')";
        }

        return $listQuery;
    }

}
