<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of RecordStructure
 *
 * @author zavad
 */
class ITS4YouWarehouses_RecordStructure_Model extends Vtiger_RecordStructure_Model
{

    /**
     * Function to get the values in stuctured format. Its overriden version
     * omits the dummy field quantity in stock which is used only for Popup
     * in distribution block.
     * @return <array> - values in structure array('block'=>array(fieldinfo));
     */
    public function getStructure()
    {
        if (!empty($this->structuredValues)) {
            return $this->structuredValues;
        }

        $values = array();
        $recordModel = $this->getRecord();
        $recordExists = !empty($recordModel);
        $moduleModel = $this->getModule();
        $blockModelList = $moduleModel->getBlocks();
        foreach ($blockModelList as $blockLabel => $blockModel) {
            $fieldModelList = $blockModel->getFields();
            if (!empty($fieldModelList)) {
                $values[$blockLabel] = array();
                foreach ($fieldModelList as $fieldName => $fieldModel) {
                    if ($fieldModel->isViewable() && $fieldName != "qtyinstock") {
                        if ($recordExists) {
                            $fieldModel->set('fieldvalue', $recordModel->get($fieldName));
                        }
                        $values[$blockLabel][$fieldName] = $fieldModel;
                    }
                }
            }
        }
        $this->structuredValues = $values;
        return $values;
    }

}
