<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_Record_Model extends Vtiger_Record_Model
{
    public $warehouseQuantities = array();

    /**
     * @throws Exception
     */
    public static function getOwnerId($record)
    {
        $adb = PearDatabase::getInstance();
        $result1 = $adb->pquery('SELECT smownerid FROM vtiger_crmentity WHERE crmid=?', array($record));

        return $adb->query_result($result1, 0, 'smownerid');
    }

    /**
     * @throws Exception
     */
    public function retrieveQuantityProduct($productId)
    {
        $this->setQuantity($productId, $this->getProductQtyInStock($productId));
    }

    /**
     * @param int $productId
     * @param float $quantity
     */
    public function setQuantity($productId, $quantity)
    {
        $this->warehouseQuantities[$productId] = floatval($quantity);
    }

    /**
     * @throws Exception
     */
    public function getProductQtyInStock($productId)
    {
        $adb = PearDatabase::getInstance();
        $result = $adb->pquery('SELECT quantity FROM its4you_warehouses_productrel WHERE warehouseid=? AND productid=?', array($this->getId(), $productId));

        return $adb->query_result($result, 0, 'quantity');
    }

    public function getQuantities()
    {
        return $this->warehouseQuantities;
    }

    /**
     * @throws Exception
     */
    public function retrieveQuantitySubProducts($productId)
    {
        /** @var Products_Record_Model $productModel */
        $productModel = Vtiger_Record_Model::getInstanceById($productId, 'Products');

        if ($productModel) {
            $subProducts = $productModel->getSubProducts();

            foreach ($subProducts as $subProductId => $subProduct) {
                $this->setQuantity($subProductId, $this->getProductQtyInStock($subProductId));
            }
        }
    }

    public function retrieveQuantitySourceRecord($recordId)
    {
        /**
         * @var $recordModel Inventory_Record_Model
         */
        $recordModel = Vtiger_Record_Model::getInstanceById($recordId);

        if ($recordModel) {
            foreach ($recordModel->getProducts() as $productKey => $productInfo) {
                $subProducts = array_filter(explode(',', $productInfo['subproduct_ids' . $productKey]));
                $productId = $productInfo['hdnProductId' . $productKey];
                $qty = $productInfo['qty' . $productKey];

                if (!empty($subProducts)) {
                    foreach ($subProducts as $subProduct) {
                        list($subProductId, $subProductQty) = explode(':', $subProduct);

                        $this->warehouseQuantities[$subProductId] += $qty * $subProductQty;
                    }
                } else {
                    $this->warehouseQuantities[$productId] += $qty;
                }
            }
        }
    }
}
