<?php
/*********************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductsInWarehouseListView_Model extends Vtiger_Base_Model
{

    private $moduleModel;

    public function __construct($values = array())
    {
        parent::__construct($values);

        $this->moduleModel = Vtiger_Module_Model::getInstance("ITS4YouWarehouses");
    }

    public function getHeaders()
    {
        return $this->moduleModel->getProductsInWarehousesFields();
    }

    public function getEntries($pagingModel)
    {
        $db = PearDatabase::getInstance();

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }
        list($searchQuery, $params) = $this->getSearchQuery($searchParams);
        $listQuery = $this->getQuery() . $searchQuery;
        $orderBy = $this->getForSql('orderby');
        $sortOrder = $this->getForSql('sortorder');

        $startIndex = $pagingModel->getStartIndex();
        $pageLimit = $pagingModel->getPageLimit();

        if (!empty($orderBy)) {
            $listQuery .= ' ORDER BY ' . $orderBy . ' ' . $sortOrder;
        } else {
            $listQuery .= ' ORDER BY modifiedtime DESC';
        }
        $listQuery .= " LIMIT $startIndex," . ($pageLimit + 1);

        $listResult = $db->pquery($listQuery, $params);
        $listViewRecordModels = array();
        $listViewEntries = $this->getListViewRecords($listResult);

        $pagingModel->calculatePageRange($listViewEntries);

        if ($db->num_rows($listResult) > $pageLimit) {
            array_pop($listViewEntries);
            $pagingModel->set('nextPageExists', true);
        } else {
            $pagingModel->set('nextPageExists', false);
        }

        $index = 0;
        foreach ($listViewEntries as $recordId => $record) {
            $rawData = $db->query_result_rowdata($listResult, $index++);
            $record['id'] = $recordId;
            $listViewRecordModels[$recordId] = $this->getRecordFromArray($record, $rawData);
        }

        return $listViewRecordModels;
    }

    private function getSearchQuery($searchParams)
    {
        $searchQuery = "";
        $params = array($this->get("warehouseid"));
        if (isset($searchParams[0]["columns"])) {
            $subSearchParams = $searchParams[0]["columns"];
            foreach ($subSearchParams as $searchParamsArr) {
                $condition = isset($searchParamsArr["column_condition"]) ? $searchParamsArr["column_condition"] : "";
                switch ($searchParamsArr["columnname"]) {
                    case "quantity":
                        $searchQuery .= $searchParamsArr["columnname"] . " = ? " . $condition . " ";
                        array_push($params, $searchParamsArr["value"]);
                        break;

                    default:
                        $searchQuery .= $searchParamsArr["columnname"] . " LIKE ? " . $condition . " ";
                        array_push($params, "%" . $searchParamsArr["value"] . "%");
                        break;
                }
            }
        }
        if ($searchQuery != "") {
            $searchQuery = " AND " . $searchQuery;
        }

        return array($searchQuery, $params);
    }

    private function getQuery()
    {
        return 'SELECT c.crmid, p.product_no, p.productname, w.quantity, w.warehouseid
	        FROM vtiger_products AS p
			INNER JOIN vtiger_crmentity AS c ON p.productid = c.crmid
	        INNER JOIN its4you_warehouses_productrel AS w ON p.productid = w.productid
	    	WHERE c.deleted = 0 AND w.warehouseid = ?';
    }

    private function getListViewRecords($_dbResult)
    {
        $db = PearDatabase::getInstance();
        $listViewEntries = array();
        while ($row = $db->fetchByAssoc($_dbResult)) {
            foreach ($row as $key => $val) {
                switch ($key) {
                    case "qty":
                        $tmpVal = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($val);
                        break;

                    default:
                        $tmpVal = $val;
                }
                $listViewEntries[$row["crmid"]][$key] = $tmpVal;
            }
        }

        return $listViewEntries;
    }

    private function getRecordFromArray($valueArray, $rawData)
    {
        $recordInstance = new ITS4YouWarehouses_ProductsInWarehouseRecord_Model();
        return $recordInstance->setData($valueArray)->setRawData($rawData);
    }

    public function getRelatedEntriesCount()
    {
        $db = PearDatabase::getInstance();

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }

        list($searchQuery, $params) = $this->getSearchQuery($searchParams);
        $listQuery = $this->getQuery() . $searchQuery;

        $position = stripos($listQuery, 'FROM');
        if ($position) {
            $explode = explode('FROM', $listQuery);
            unset($explode[0]);

            $listQuery = 'SELECT count(*) AS count FROM ' . implode('FROM', $explode);
        }

        $listResult = $db->pquery($listQuery, $params);
        return $db->query_result($listResult, 0, 'count');
    }

}


