<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_Products_Helper
{
    /**
     * @param object $parentRecordModel
     * @param array $lineItemQuantities
     * @return array
     * @throws Exception
     */
    public static function getReturnProducts($parentRecordModel, $lineItemQuantities)
    {
        $relatedProducts = [];
        $sourceRecord = $parentRecordModel->getId();
        $sourceModule = $parentRecordModel->getModuleName();
        $parentRelatedProducts = ITS4YouWarehouses_InventoryUtils_Helper::getAssociatedProducts($parentRecordModel->getEntity());
        //adjust relatedProducts, consider the user option from previous DIV

        $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory($sourceModule, $sourceRecord);
        $actionBlockLineItems = $actionBlock->getLineItems();

        $productsCount = count($parentRelatedProducts);

        for ($i = 1; $i <= $productsCount; $i++) {
            $lineItemId = $parentRelatedProducts[$i]["lineItemId" . $i];

            if ($lineItemQuantities[$lineItemId] > 0) {
                $cloneItem = $parentRelatedProducts[$i];
                //fix indexes in array keys

                foreach ($cloneItem as $key => $val) {
                    $filteredKey = self::fixFieldIndex($i, $key);

                    if ('final_details' !== $key) {
                        $relatedProducts[$i][$filteredKey] = $val;
                    }
                }

                $relatedProducts[$i]["qty$i"] = $lineItemQuantities[$lineItemId];

                if (isset($actionBlockLineItems[$lineItemId])) {
                    $relatedProducts[$i]["maxQty$i"] = $actionBlockLineItems[$lineItemId]->getAdjustedQuantity() - 1;
                    $relatedProducts[$i]["qtyInStock$i"] = $actionBlockLineItems[$lineItemId]->getQuantity();
                } else {
                    //this branch should be never accessed
                    $relatedProducts[$i]["maxQty$i"] = 0;
                    $relatedProducts[$i]["qtyInStock$i"] = 0;
                }
                //add source lineItemId for CrossInventoryRel
                $relatedProducts[$i]["lineItemId$i"] = $lineItemId;
            }
        }

        return $relatedProducts;
    }

    /**
     * @param $index
     * @param $key
     * @return string|string[]|null
     */
    public static function fixFieldIndex($index, $key)
    {
        return preg_replace("/(?![\D]+)([\d]+)/", $index, $key, 1);
    }

    /**
     * @param Vtiger_Request $request
     * @return array
     */
    public static function getItemsQtyFromRequest(Vtiger_Request $request)
    {
        $data = $request->getAll();
        $lineItems = [];

        foreach ($data as $name => $value) {
            if (false !== strpos($name, 'lineItemId')) {
                $lineItems[$value] = $request->get('lineItemQty' . str_replace('lineItemId', '', $name), 0);
            }
        }

        return $lineItems;
    }

    /**
     * @param Vtiger_Request $request
     * @param $values
     * @return array
     */
    public static function getLineItemsFromRequest(Vtiger_Request $request, $values)
    {
        $data = $request->getAll();
        $lineItems = [];
        $lineItemIdName = $values[0];

        foreach ($data as $fieldName => $fieldValue) {
            $rawFieldName = preg_replace('/[0-9]*/', '', $fieldName);

            if ($rawFieldName === $lineItemIdName) {
                $lineItemId = str_replace($lineItemIdName, '', $fieldName);

                foreach ($values as $value) {
                    $lineItems[$fieldValue][$value] = $request->get($value . $lineItemId, '');
                }
            }
        }

        return $lineItems;
    }
}
