<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductMovementsBlock_Helper
{

    /** @var int Product ID */
    private $productId;

    public function __construct($_productId)
    {
        $this->productId = $_productId;
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getSideWidgetViewModel()
    {
        $listViewModel = new ITS4YouWarehouses_ProductMovementsListView_Model();
        $listViewModel->setProductId($this->productId);

        $moduleModelPool = array();
        $viewModel["totalEntries"] = $listViewModel->getListViewCount();
        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set("limit", 10);
        $entries = $listViewModel->getEntries($pagingModel);
        $viewModel["movements"] = array();
        foreach ($entries as $recordModel) {
            if (!isset($moduleModelPool[$recordModel->get("setype")])) {
                $moduleModelPool[$recordModel->get("setype")] = Vtiger_Module_Model::getInstance($recordModel->get("setype"));
            }

            $viewModel["movements"][] = array(
                "quantity" => $recordModel->get("qty"),
                "sign" => $recordModel->get("sign"),
                "tooltip" => DateTimeField::convertToUserFormat($recordModel->get("doc_date")),
                "detail_info" => $recordModel->get("record_no"),
                "url" => $moduleModelPool[$recordModel->get("setype")]->getDetailViewUrl($recordModel->get("crmid"))
            );
        }
        return $viewModel;
    }

}
