<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductInWarehousesBlock_Helper
{

    private $productId;

    public function __construct($_productId)
    {
        $this->productId = $_productId;
    }

    public function getSideWidgetViewModel()
    {
        $viewModel = array();
        $listViewModel = new ITS4YouWHDeliveryNotes_ProductInWarehousesListView_Model();
        $listViewModel->setProductId($this->productId);

        $moduleModel = Vtiger_Module_Model::getInstance("ITS4YouWarehouses");

        $viewModel["totalEntries"] = $listViewModel->getListViewCount();
        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set("limit", 10);
        $entries = $listViewModel->getEntries($pagingModel);

        $viewModel["warehouses"] = array();
        foreach ($entries as $recordModel) {
            $viewModel["warehouses"][] = array(
                "quantity" => $recordModel->get("quantity"),
                "tooltip" => $recordModel->get("warehouse_name"),
                "detail_info" => $recordModel->get("warehouse_no"),
                "url" => $moduleModel->getDetailViewUrl($recordModel->get("crmid"))
            );
        }

        return $viewModel;
    }

}
