<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ItemStatusActionViewModel_Helper
{

    private $statusId;
    private $singleAction;
    private $buttonActions;

    /**
     * @param int $_statusId
     * @param string $_singleAction
     */
    public function __construct($_statusId, $_singleAction)
    {
        $this->statusId = $_statusId;
        $this->singleAction = $_singleAction;
        $this->buttonActions = array();
    }

    /**
     * @return string
     */
    public function getSingleAction()
    {
        return $this->singleAction;
    }

    /**
     * @return bool
     */
    public function isAnyButtonDefined()
    {
        return count($this->buttonActions) > 0;
    }

    /**
     * Return mass action button
     * @param int $_buttonIdx
     * @return ITS4YouWarehouses_ButtonActionViewModel_Helper
     */
    public function getButton($_buttonIdx = 0)
    {
        if (isset($this->buttonActions[$_buttonIdx])) {
            return $this->buttonActions[$_buttonIdx];
        } else {
            return null;
        }
    }

    /**
     * @param string $_buttonAction
     * @param string $_buttonStyle
     * @param string $_buttonLabel
     * @param string $_buttonTitle
     */
    public function addButton($_buttonAction, $_buttonStyle, $_buttonLabel, $_buttonTitle)
    {
        $this->buttonActions[] = new ITS4YouWarehouses_ButtonActionViewModel_Helper($_buttonAction, $_buttonStyle, $_buttonLabel, $_buttonTitle);
    }

}