<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class CustomPOEventHandler extends VTEventHandler
{

    /**
     * Handle event
     * @param string $handlerType
     * @param VTEntityData $entityData
     * @global PearDatabase $adb
     */
    public function handleEvent($handlerType, $entityData)
    {
        switch ($handlerType) {
            //avoid updating Qty in stock via standard functionality in method save_module of class PurchaseOrder
            case 'vtiger.entity.beforesave':
                if ('PurchaseOrder' !== $entityData->getModuleName()) {
                    return;
                }

                $entityData->focus->update_prod_stock = 'false';
                break;

            //save PO as related module of SO, INV  
            case 'vtiger.entity.aftersave':
                if (!empty($_REQUEST['sourceModule']) &&
                    !empty($_REQUEST['sourceRecord']) &&
                    in_array($_REQUEST['sourceModule'], ['SalesOrder', 'Invoice'])
                ) {
                    $purchaseOrder = Vtiger_Module_Model::getInstance('PurchaseOrder');
                    $sourceModule = Vtiger_Module_Model::getInstance($_REQUEST['sourceModule']);

                    if(!$purchaseOrder || !$sourceModule) {
                        return;
                    }

                    /* @var $relationModel Vtiger_Relation_Model */
                    $relationModel = Vtiger_Relation_Model::getInstance($sourceModule, $purchaseOrder);

                    if (is_object($relationModel)) {
                        $relationModel->addRelation($_REQUEST['sourceRecord'], $entityData->getId());
                    }
                }
                break;
        }
    }

}