<?php
/* ********************************************************************************
 * The content of this file is subject to the ITS4YouWarehouses license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_InventoryMassSave_Action extends Inventory_MassSave_Action
{
    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $recordModels = $this->getRecordModelsFromRequest($request);

        foreach ($recordModels as $recordId => $recordModel) {
            if (Users_Privileges_Model::isPermitted($moduleName, 'Save', $recordId)) {
                if (!ITS4YouWarehouses_SeqStatusActionHandler_Helper::isStatusDisabledForModule($moduleName, $recordModel->get(ITS4YouWarehouses_Util_Helper::getStatusField($moduleName)))) {
                    //Inventory line items getting wiped out
                    $_REQUEST['ajxaction'] = 'DETAILVIEW';
                    $recordModel->save();
                }
            }
        }

        $response = new Vtiger_Response();
        $response->setResult(true);
        $response->emit();
    }
}
