<?php
/* ********************************************************************************
 * The content of this file is subject to the ITS4YouWarehouses license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_InventoryMassDelete_Action extends Vtiger_Mass_Action
{
    /**
     * @param Vtiger_Request $request
     * @throws AppException
     */
    public function checkPermission(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $currentUserPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();

        if (!$currentUserPrivilegesModel->hasModuleActionPermission($moduleModel->getId(), 'Delete')) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $recordIds = $this->getRecordsListFromRequest($request);
        $permission = 'Yes';

        foreach ($recordIds as $recordId) {
            if (Users_Privileges_Model::isPermitted($moduleName, 'Delete', $recordId)) {
                $recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleModel);

                if (!ITS4YouWarehouses_SeqStatusActionHandler_Helper::isStatusDisabledForModule($moduleName, $recordModel->get(ITS4YouWarehouses_Util_Helper::getStatusField($moduleName)))) {
                    $recordModel->delete();
                }
            } else {
                $permission = 'No';
            }
        }

        if ('No' === $permission) {
            throw new AppException(vtranslate('LBL_PERMISSION_DENIED'));
        }

        $response = new Vtiger_Response();
        $response->setResult(array('viewname' => $request->get('viewname'), 'module' => $moduleName));
        $response->emit();
    }
}
