<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_GetQtyInStock_Action extends Vtiger_Action_Controller
{

    /**
     * @param Vtiger_Request $request
     * @return bool
     */
    public function checkPermission(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     */
    public function preProcess(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     */
    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $this->getQtyInStock($request);
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function getQtyInStock(Vtiger_Request $request)
    {
        /**
         * @var $warehouseModel ITS4YouWarehouses_Record_Model
         */
        $warehouseModel = Vtiger_Record_Model::getInstanceById($request->get('record'));
        $productId = $request->get('productid');

        $warehouseModel->retrieveQuantityProduct($productId);
        $warehouseModel->retrieveQuantitySubProducts($productId);

        if (!$request->isEmpty('sourceRecord')) {
            $warehouseModel->retrieveQuantitySourceRecord($request->get('sourceRecord'));
        }

        $response = new Vtiger_Response();
        $response->setResult($warehouseModel->getQuantities());
        $response->emit();
    }

    /**
     * @param Vtiger_Request $request
     * @return bool
     */
    public function validateRequest(Vtiger_Request $request)
    {
        return true;
    }

}
