<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Class ITS4YouWarehouses_WT_ActionBlock
 */
class ITS4YouWarehouses_WT_ActionBlock extends ITS4YouWarehouses_Base_ActionBlock implements ITS4YouWarehouses_IStatusActionBlock_Sequential
{

    /**
     * @var
     */
    private $wtStatus;

    /**
     * ITS4YouWarehouses_WT_ActionBlock constructor.
     * @param $_parentId
     * @throws Exception
     */
    protected function __construct($_parentId)
    {
        parent::__construct($_parentId);

        $this->readParentAttributes();
    }

    /**
     * @throws Exception
     */
    private function readParentAttributes()
    {
        $db = PearDatabase::getInstance();

        $sql = "SELECT wtstatus
                FROM its4you_warehousetransfers
                WHERE warehousetransferid = ?";
        $result = $db->pquery($sql, array($this->parentId));
        if ($db->num_rows($result) > 0) {
            $this->wtStatus = $db->query_result($result, 0, "wtstatus");
        }
    }

    /**
     * @throws Exception
     */
    public function getChangeStatusDeliverViewModel()
    {
        throw new Exception("MultiWarehouses4You :: Not implemented.");
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getSeqStatusViewModel()
    {
        $actions = array();
        $moduleName = "ITS4YouWarehouseTransfers";

        if ($this->wtStatus != "Canceled") {
            $actions[] = array(
                "url" => "javascript: void(0);",
                "label" => vtranslate("LBL_CANCEL_WT", $moduleName),
                "class" => "btn-warning action" . ITS4YouWarehouses_WTStatusPool_Sequential::ACTION_MODE_CANCEL
            );
        }

        $seqStatusInstance = ITS4YouWarehouses_WTStatusPool_Sequential::getInstance()->getFirst();
        /* @var $seqStatusInstance ITS4YouWarehouses_IStatus_Sequential */
        $sequentialStatuses = array();
        while ($seqStatusInstance != null) {
            if ($this->wtStatus != "Canceled") {
                if ($seqStatusInstance->getId() != "Canceled") {
                    $sequentialStatuses[$seqStatusInstance->getId()] = $this->wtStatus == $seqStatusInstance->getId();
                }
            } else {
                $sequentialStatuses[$seqStatusInstance->getId()] = $this->wtStatus == $seqStatusInstance->getId();
                if ($seqStatusInstance->getId() == $this->getPreCanceledStatus()) {
                    $sequentialStatuses["Canceled"] = true;
                    break;
                }
            }
            $seqStatusInstance = $seqStatusInstance->getNext();
        }

        return array(
            "actions" => $actions,
            "sequential_statuses" => $sequentialStatuses
        );
    }

    /**
     * @return mixed|null
     * @throws Exception
     */
    private function getPreCanceledStatus()
    {
        if (!file_exists("modules/ModTracker/ModTracker.php")) {
            return null;
        }
        require_once "modules/ModTracker/ModTracker.php";

        $db = PearDatabase::getInstance();
        // modifiedtime could be better for performance but Edit must be disabled once the WT is canceled
        $sql = "SELECT createdtime FROM vtiger_crmentity WHERE crmid = ?";
        $result = $db->pquery($sql, array($this->parentId));
        $time = $db->query_result($result, 0, "createdtime");
        $fieldChanges = ModTracker::getRecordFieldChanges($this->parentId, strtotime($time));

        if (isset($fieldChanges["wtstatus"]) && $fieldChanges["wtstatus"]["postvalue"] == "Canceled") {
            return $fieldChanges["wtstatus"]["prevalue"];
        } else {
            return null;
        }
    }

}
