<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_StatusActionsPoolBase_ActionBlock
{

    /**
     * @var null
     */
    private static $instance = null;

    /**
     * @var array Array of all statuses actions
     */
    private $statusActions = array();

    /**
     * ITS4YouWarehouses_StatusActionsPoolBase_ActionBlock constructor.
     */
    protected function __construct()
    {
        $this->initStatusActions();
    }

    protected function initStatusActions()
    {
        //AVAILABLE
        $actionViewModelAvailable = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AVAILABLE, 'actionShowOverview');
        $actionViewModelAvailable->addButton("actionAvailableButton", "btn", "Create DeliveryNote", "LBL_CREATE_DELIVERYNOTE");
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AVAILABLE] = $actionViewModelAvailable;

        //NOT AVAILABLE
        $actionViewModelNA = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_NOTAVAILABLE, 'actionShowOverview');
        $actionViewModelNA->addButton("actionNotAvailableButton", "btn", "LBL_CREATE_PO", "LBL_CREATE_PURCHASEORDER");
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_NOTAVAILABLE] = $actionViewModelNA;

        //AVAILABLE_PART same $actionViewModel as AVAILABLE
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AVAILABLE_PART, 'actionShowOverview');
        $availableButton = $actionViewModelAvailable->getButton();
        $actionViewModel->addButton($availableButton->getButtonAction(), $availableButton->getButtonStyle(), $availableButton->getButtonLabel(), $availableButton->getButtonTitle());
//        $notAvailableButton = $actionViewModelNA->getButton();
//        $actionViewModel->addButton($notAvailableButton->getButtonAction(), $notAvailableButton->getButtonStyle(), $notAvailableButton->getButtonLabel(), $notAvailableButton->getButtonTitle());
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AVAILABLE_PART] = $actionViewModel;

        //AWAITING
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AWAITING, 'actionShowOverview');
        $actionViewModel->addButton("actionAwaitingButton", "btn", "LBL_CREATE_IC", "LBL_CREATE_IC");
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AWAITING] = $actionViewModel;

        //ISSUED
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_ISSUED, 'actionShowOverview');
        $actionViewModel->addButton("actionIssuedButton", "btn", "LBL_DELIVER_CUSTOMER", "LBL_DELIVER_CUSTOMER_DESC2");
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_ISSUED] = $actionViewModel;

        //INVOICED
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_INVOICED, 'actionShowOverview');
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_INVOICED] = $actionViewModel;

        //TOBEINVOICED
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_TOBEINVOICED, 'actionShowOverview');
        $actionViewModel->addButton("actionToBeInvoicedButton", "btn", "LBL_CREATE_INV", "LBL_CREATE_INVOICE");
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_TOBEINVOICED] = $actionViewModel;

        //AVAILABLE_EXIST
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AVAILABLE_EXIST, 'actionShowOverview');
        $actionViewModel->addButton("actionAvailableExistButton", "btn", "LBL_ADD_TO_DN", "LBL_ADD_TO_DELIVERYNOTE");
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AVAILABLE_EXIST] = $actionViewModel;

        //RECEIPTED
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_RECEIPTED, 'actionShowOverview');
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_RECEIPTED] = $actionViewModel;

        //CANCELED
        $actionViewModel = new ITS4YouWarehouses_ItemStatusActionViewModel_Helper(ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_CANCELED, "actionShowOverview");
        $this->statusActions[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_CANCELED] = $actionViewModel;
    }

    /**
     * @return ITS4YouWarehouses_StatusActionsPoolBase_ActionBlock|null
     */
    public static function getInstance()
    {
        if (self::$instance == null) {
            self::$instance = new ITS4YouWarehouses_StatusActionsPoolBase_ActionBlock();
        }

        return self::$instance;
    }

    /**
     * Get specific status action
     * @param string $_statusId
     * @return ITS4YouWarehouses_ItemStatusActionViewModel_Helper
     */
    public function getStatusAction($_statusId)
    {
        return isset($this->statusActions[$_statusId]) ? $this->statusActions[$_statusId] : null;
    }

    /**
     * Set specific status action
     * @param string $_statusId
     * @param ITS4YouWarehouses_ItemStatusActionViewModel_Helper $_statusActionViewModel
     */
    protected function setStatusAction($_statusId, $_statusActionViewModel)
    {
        $this->statusActions[$_statusId] = $_statusActionViewModel;
    }
}
