<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

abstract class ITS4YouWarehouses_ItemStatus_ActionBlock
{

    const STATUS_NOTAVAILABLE = "NOTA";
    const STATUS_AVAILABLE = "AVAI";
    const STATUS_DELIVERED = "DELI";
    const STATUS_INVOICED = "INVO";
    const STATUS_AWAITING = "AWAI";
    const STATUS_ISSUED = "ISSU";
    const STATUS_TOBEINVOICED = "2BIN";
    const STATUS_AVAILABLE_EXIST = "AVEX";
    const STATUS_RECEIPTED = "RECE";
    const STATUS_AVAILABLE_PART = "AVPA";
    const STATUS_CANCELED = "CANC";
    const STATUS_RETURNED = "RETU";

    protected $id;
    protected $name;
    protected $itemQty;
    protected $isAdjustingQty;

    /** @var bool Flag if the status quantity is set explicitly from ActionBlock or is implicitly calculated */
    protected $isExplicit;
    protected $displayPrio;
    protected $isIndividually;

    protected function __construct($_id, $_name, $_isAdjustingQty, $_isExplicit, $_displayPrio, $_itemQty)
    {
        $this->id = $_id;
        $this->name = $_name;
        $this->isAdjustingQty = $_isAdjustingQty;
        $this->isExplicit = $_isExplicit;
        $this->displayPrio = $_displayPrio;
        $this->itemQty = $_itemQty;
    }

    /**
     * Compare two instances of ITS4YouWarehouses_ItemStatus_ActionBlock class
     * @param ITS4YouWarehouses_ItemStatus_ActionBlock $_statusInstance1
     * @param ITS4YouWarehouses_ItemStatus_ActionBlock $_statusInstance2
     * @return int
     */
    public static function compare($_statusInstance1, $_statusInstance2)
    {
        if ($_statusInstance1->displayPrio == $_statusInstance2->displayPrio) {
            return 0;
        }

        return $_statusInstance1->displayPrio < $_statusInstance2->displayPrio ? -1 : 1;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getIsIndividually()
    {
        return $this->isIndividually;
    }

    public function getIsAdjustingQty()
    {
        return $this->isAdjustingQty;
    }

    public function getIsExplicit()
    {
        return $this->isExplicit;
    }

    public function getDisplayPrio()
    {
        return $this->displayPrio;
    }

    public function getItemQty()
    {
        return $this->itemQty;
    }

    public function setItemQty($_itemQty)
    {
        $this->itemQty = $_itemQty;
    }

}