<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */
/**
 * Represent action block item for inbound modules (i.e. Purchase Order)
 */
class ITS4YouWarehouses_ItemInbound_ActionBlock extends ITS4YouWarehouses_Item_ActionBlock
{

    /**
     * Modify (create or update) explicit status and its quantity
     */
    protected function modifyImplicitStatuses()
    {
        if ($this->restQty > 0) {
            $this->statuses[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AWAITING] = new ITS4YouWarehouses_ItemStatusAwaiting_ActionBlock($this->restQty);
        } else {
            unset($this->statuses[ITS4YouWarehouses_ItemStatus_ActionBlock::STATUS_AWAITING]);
        }
    }

}