<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_IP_ActionBlock
{
    /**
     * @param $_selectedLineItemIds
     * @return array
     * @throws AppException
     * @throws Exception
     */
    public function getWaitingAvailabilityActionViewModel($_selectedLineItemIds)
    {
        //collect purchase order IDs that are to be processed
        $purchaseOrderIds = array();
        foreach ($_selectedLineItemIds as $lineItemId) {
            $lineItem = ITS4YouWarehouses_InventoryLineItem_Helper::getLineItemFromDB($lineItemId);
            if (getSalesEntityType($lineItem->getParentId()) == "PurchaseOrder") {
                $purchaseOrderIds[$lineItem->getParentId()][$lineItem->getProductId()] = $lineItem->getProductId();
            }
        }
        //collect relevant line items
        $items = array();
        $tmpViewModel = array();

        foreach ($purchaseOrderIds as $purchaseOrderId => $productIds) {
            $tmpActionBlock = ITS4YouWarehouses_Base_ActionBlock::factory("PurchaseOrder", $purchaseOrderId);
            $tmpViewModel = $tmpActionBlock->getWaitingAvailabilityActionViewModel($productIds);
            //filter view model according to specific line items
            foreach ($tmpViewModel["items"] as $lineItemId => $viewData) {
                if (in_array($lineItemId, $_selectedLineItemIds)) {
                    $items[$lineItemId] = $viewData;
                }
            }
        }
        //return view model array; other settings are taken from last looped $tmpViewModel
        return array("items" => $items, "other" => $tmpViewModel["other"]);
    }

}
