<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Class ITS4YouWarehouses_DNUtil_ActionBlock
 */
class ITS4YouWarehouses_DNUtil_ActionBlock
{

    /**
     * @param <number> $_deliveryNoteId
     * @throws Exception
     */
    public static function updateRelatedSalesOrderStatus($_deliveryNoteId)
    {
        global $adb;

        $sql = "SELECT vtiger_salesorder.salesorderid,
                    vtiger_salesorder.sostatus
                FROM vtiger_salesorder
                INNER JOIN its4you_deliverynotes
                    ON its4you_deliverynotes.referenceid = vtiger_salesorder.salesorderid
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid = vtiger_salesorder.salesorderid
                WHERE vtiger_crmentity.deleted = 0
                    AND vtiger_salesorder.sostatus <> 'Cancelled'
                    AND its4you_deliverynotes.deliverynoteid = ?";
        $result = $adb->pquery($sql, array($_deliveryNoteId));

        if ($adb->num_rows($result) > 0) {
            $salesOrderId = $adb->query_result($result, 0, "salesorderid");
            $oldStatus = $adb->query_result($result, 0, "sostatus");

            $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory("SalesOrder", $salesOrderId);
            //if all related DN are Delivered or Invoiced then set status of SO to Delivered
            $newStatus = "";
            if ($actionBlock->isCompletelyInvoiced()) {
                $newStatus = "Delivered";
            } elseif ($oldStatus == "Delivered") {  // else if current SO status is Delivered then change it to Approved
                $newStatus = "Created";
            }

            if ($newStatus != "") {
                $sql = "UPDATE vtiger_salesorder SET sostatus = ? WHERE salesorderid = ?";
                $adb->pquery($sql, array($newStatus, $salesOrderId));

                self::forceModTracker($salesOrderId, "SalesOrder", array("sostatus" => array("oldValue" => $oldStatus, "currentValue" => $newStatus)));
            }
        }
    }

    /**
     * @param $recordId
     * @param $moduleName
     * @param $fieldValues
     */
    public static function forceModTracker($recordId, $moduleName, $fieldValues)
    {
        global $adb, $current_user;

        if (!file_exists("modules/ModTracker/ModTracker.php")) {
            return;
        }
        require_once "modules/ModTracker/ModTracker.php";

        $sql = "UPDATE vtiger_crmentity SET modifiedtime = ? WHERE crmid = ?";
        $modifiedTime = date('Y-m-d H:i:s', time());
        $adb->pquery($sql, array($modifiedTime, $recordId));

        $newId = $adb->getUniqueId('vtiger_modtracker_basic');
        $params = array($newId, $recordId, $moduleName, $current_user->id, $modifiedTime, ModTracker::$UPDATED);
        $sql = "INSERT INTO vtiger_modtracker_basic(id, crmid, module, whodid, changedon, status) VALUES(?,?,?,?,?,?)";
        $adb->pquery($sql, $params);

        foreach ($fieldValues as $fieldName => $values) {
            $params = array($newId, $fieldName, $values['oldValue'], $values['currentValue']);
            $sql = "INSERT INTO vtiger_modtracker_detail(id,fieldname,prevalue,postvalue) VALUES(?,?,?,?)";
            $adb->pquery($sql, $params);
        }
    }

    /**
     * @param $_deliveryNoteId
     * @return array
     */
    public static function getRelatedSalesOrder($_deliveryNoteId)
    {
        global $adb;

        $sql = "SELECT vtiger_crmentityrel.crmid 
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                        ON vtiger_crmentity.crmid = vtiger_crmentityrel.crmid
                WHERE vtiger_crmentity.deleted = 0
                  AND vtiger_crmentityrel.module = ? 
                  AND vtiger_crmentityrel.relmodule = ? 
                  AND vtiger_crmentityrel.relcrmid = ?";
        $result = $adb->pquery($sql, array("SalesOrder", "ITS4YouWHDeliveryNotes", $_deliveryNoteId));
        $salesOrderIds = array();
        //only one SalesOrder should be related to the Delivery Note
        while ($row = $adb->fetchByAssoc($result)) {
            $salesOrderIds[$row["crmid"]] = $row["crmid"];
        }

        return $salesOrderIds;
    }

    /**
     * @param $_deliveryNoteId
     * @return array
     */
    public static function getRelatedInvoice($_deliveryNoteId)
    {
        global $adb;

        $sql = "SELECT vtiger_crmentityrel.crmid 
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                        ON vtiger_crmentity.crmid = vtiger_crmentityrel.crmid
                WHERE vtiger_crmentity.deleted = 0
                  AND vtiger_crmentityrel.module = ? 
                  AND vtiger_crmentityrel.relmodule = ? 
                  AND vtiger_crmentityrel.relcrmid = ?";
        $result = $adb->pquery($sql, array("Invoice", "ITS4YouWHDeliveryNotes", $_deliveryNoteId));
        $invoiceIds = array();
        //only one SalesOrder should be related to the Delivery Note
        while ($row = $adb->fetchByAssoc($result)) {
            $invoiceIds[$row["crmid"]] = $row["crmid"];
        }

        return $invoiceIds;
    }

    /**
     * @param $_deliveryNoteId
     * @param $_statuses
     * @return array
     */
    public static function getRelatedReceiptcards($_deliveryNoteId, $_statuses)
    {
        $db = PearDatabase::getInstance();

        $sql = "SELECT vtiger_crmentityrel.relcrmid, its4you_receiptcards.receiptcards_no
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=vtiger_crmentityrel.relcrmid
                INNER JOIN its4you_receiptcards
                    ON vtiger_crmentity.crmid=its4you_receiptcards.receiptcardid
                WHERE vtiger_crmentity.deleted = 0 
                    AND vtiger_crmentityrel.crmid=? 
                    AND vtiger_crmentityrel.module=? 
                    AND vtiger_crmentityrel.relmodule=?
                    AND its4you_receiptcards.receiptcardstatus IN (" . generateQuestionMarks($_statuses) . ")";
        $params = array_merge(array($_deliveryNoteId, "ITS4YouWHDeliveryNotes", "ITS4YouReceiptcards"), $_statuses);
        $result = $db->pquery($sql, $params);
        $receiptCards = array();
        if ($db->num_rows($result) > 0) {
            while ($row = $db->fetchByAssoc($result)) {
                $receiptCards[$row["relcrmid"]] = $row["receiptcards_no"];
            }
        }

        return $receiptCards;
    }

    /**
     * @param $_deliveryNoteId
     * @param $_newStatus
     * @throws AppException
     */
    public static function setNewParentStatus($_deliveryNoteId, $_newStatus)
    {
        $dnRecordModel = Vtiger_Record_Model::getInstanceById($_deliveryNoteId, "ITS4YouWHDeliveryNotes");
        $dnRecordModel->set("mode", "edit");
        $dnRecordModel->set("deliverynotestatus", $_newStatus);
        $dnRecordModel->save();

        $issueCardIDs = array();
        $issueCardStatus = "";
        switch ($_newStatus) {
            case "Ready to Deliver":
                $issueCardIDs = ITS4YouWarehouses_DNUtil_ActionBlock::getRelatedIssueCards($_deliveryNoteId, array("Approved"));
                $issueCardStatus = "Transferred from Warehouse";
                break;

            case "Delivered":
            case "Invoiced":
                $issueCardIDs = ITS4YouWarehouses_DNUtil_ActionBlock::getRelatedIssueCards($_deliveryNoteId, array("Transferred from Warehouse"));
                $issueCardStatus = "Delivered";
                break;

            case "Canceled":
                $issueCardIDs = ITS4YouWarehouses_DNUtil_ActionBlock::getRelatedIssueCards($_deliveryNoteId, array("Created", "Approved", "Transferred from Warehouse", "Delivered"));
                $issueCardStatus = "Canceled";
                break;
        }

        if (count($issueCardIDs) > 0) {
            foreach ($issueCardIDs as $issueCardID => $issueCardNo) {
                $icRecordModel = Vtiger_Record_Model::getInstanceById($issueCardID, "ITS4YouIssuecards");
                $icRecordModel->set("mode", "edit");
                $icRecordModel->set("issuecardstatus", $issueCardStatus);
                $icRecordModel->save();
            }
        }
    }

    /**
     * @param $_deliveryNoteId
     * @param $_statuses
     * @return array
     */
    public static function getRelatedIssueCards($_deliveryNoteId, $_statuses)
    {
        global $adb;

        $sql = "SELECT vtiger_crmentityrel.relcrmid, its4you_issuecards.issuecards_no
                FROM vtiger_crmentityrel 
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid=vtiger_crmentityrel.relcrmid
                INNER JOIN its4you_issuecards
                    ON vtiger_crmentity.crmid=its4you_issuecards.issuecardid
                WHERE vtiger_crmentity.deleted = 0 
                    AND vtiger_crmentityrel.crmid=? 
                    AND vtiger_crmentityrel.module=? 
                    AND vtiger_crmentityrel.relmodule=?
                    AND its4you_issuecards.issuecardstatus IN (" . generateQuestionMarks($_statuses) . ")";
        $params = array_merge(array($_deliveryNoteId, "ITS4YouWHDeliveryNotes", "ITS4YouIssuecards"), $_statuses);
        $result = $adb->pquery($sql, $params);
        $issueCardIDs = array();
        if ($adb->num_rows($result) > 0) {
            while ($row = $adb->fetchByAssoc($result)) {
                $issueCardIDs[$row["relcrmid"]] = $row["issuecards_no"];
            }
        }

        return $issueCardIDs;
    }

    /**
     * @param $_deliveryNoteId
     * @throws AppException
     */
    public static function trashRelatedIssueCards($_deliveryNoteId)
    {
        $issueCardIDs = ITS4YouWarehouses_DNUtil_ActionBlock::getRelatedIssueCards($_deliveryNoteId, array("Created", "Approved", "Transferred from Warehouse", "Delivered", "Canceled"));
        if (count($issueCardIDs) > 0) {
            foreach ($issueCardIDs as $issueCardID => $issueCardNo) {
                $recordModel = Vtiger_Record_Model::getInstanceById($issueCardID);
                $recordModel->delete();
            }
        }
    }
}