<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouseTransfers_ReturnProducts_View extends Inventory_Edit_View
{

    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $jsFileNames = array(
            'modules.ITS4YouWarehouseTransfers.resources.ReturnProducts',
        );
        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $record = $request->get('record');
        $sourceRecord = $request->get('sourceRecord');
        $sourceModule = $request->get('sourceModule');

        $recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);
        $lineItemQuantities = ITS4YouWarehouses_Products_Helper::getItemsQtyFromRequest($request);

        $rcRecordModel = Vtiger_Record_Model::getInstanceById($sourceRecord);
        if ($rcRecordModel->get("receiptcardtype") != "Warehouse transfer" || getSalesEntityType($rcRecordModel->get("vendor_id")) !== "ITS4YouWarehouseTransfers") {
            throw new Exception("MultiWarehouses4You :: Only Receipt Card related to Warehouse Transfer can be used.");
        }
        $currencyInfo = $rcRecordModel->getCurrencyInfo();
        $taxes = $rcRecordModel->getProductTaxes();
        $shippingTaxes = $rcRecordModel->getShippingTaxes();
        $relatedProducts = ITS4YouWarehouses_Products_Helper::getReturnProducts($rcRecordModel, $lineItemQuantities);

        $parentRecordModel = Inventory_Record_Model::getInstanceById($rcRecordModel->get("vendor_id"));
        $recordModel->setRecordFieldValues($parentRecordModel);
        $recordModel->set("subject", "");
        $currentUserDate = Vtiger_Functions::currentUserDisplayDateNew();
        $dateValue = (new DateTimeField((string) $currentUserDate))->getDBInsertDateValue();
        $recordModel->set("required_del_date", $dateValue);
        $recordModel->set("duedate", $dateValue);
        $recordModel->set("towarehouseid", $parentRecordModel->get("fromwarehouseid"));
        $recordModel->set("fromwarehouseid", $parentRecordModel->get("towarehouseid"));
        //we are creating relationship between RC and new WT
        $viewer->assign("PARENT_ID", $rcRecordModel->getId());

        $moduleModel = $recordModel->getModule();
        $fieldList = $moduleModel->getFields();
        $requestFieldList = array_intersect_key($request->getAll(), $fieldList);

        //get the inventory terms and conditions
        $inventoryRecordModel = Inventory_Record_Model::getCleanInstance($moduleName);
        $termsAndConditions = $inventoryRecordModel->getInventoryTermsandConditions();

        foreach ($requestFieldList as $fieldName => $fieldValue) {
            $fieldModel = $fieldList[$fieldName];
            if ($fieldModel->isEditable()) {
                $recordModel->set($fieldName, $fieldModel->getDBInsertValue($fieldValue));
            }
        }
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);

        $viewer->assign('VIEW_MODE', "fullForm");

        $isRelationOperation = $request->get('relationOperation');

        //if it is relation edit
        $viewer->assign('IS_RELATION_OPERATION', $isRelationOperation);
        if ($isRelationOperation) {
            $viewer->assign('SOURCE_MODULE', $sourceModule);
            $viewer->assign('SOURCE_RECORD', $sourceRecord);
        }
        if (!empty($record) && $request->get('isDuplicate') == true) {
            $viewer->assign('IS_DUPLICATE', true);
        } else {
            $viewer->assign('IS_DUPLICATE', false);
        }
        $currencies = Inventory_Module_Model::getAllCurrencies();
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);

        $viewer->assign('PICKIST_DEPENDENCY_DATASOURCE', Zend_Json::encode($picklistDependencyDatasource));
        $viewer->assign('RECORD', $recordModel);
        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('CURRENTDATE', date('Y-n-j'));
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());

        $viewer->assign('RELATED_PRODUCTS', $relatedProducts);
        $viewer->assign('SHIPPING_TAXES', $shippingTaxes);
        $viewer->assign('TAXES', $taxes);
        $viewer->assign('CURRENCINFO', $currencyInfo);
        $viewer->assign('CURRENCIES', $currencies);
        $viewer->assign('TERMSANDCONDITIONS', $termsAndConditions);

        $viewer->assign('PRODUCT_ACTIVE', false);
        $viewer->assign('SERVICE_ACTIVE', false);

        $viewer->view('EditView.tpl', $moduleName);
    }

}
