<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouseTransfers_ProductsPopupAjax_View extends ITS4YouWarehouseTransfers_ProductsPopup_View
{

    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('getListViewCount');
        $this->exposeMethod('getRecordsCount');
        $this->exposeMethod('getPageCount');
    }

    public function preProcess(Vtiger_Request $request)
    {
        return true;
    }

    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
        $viewer = $this->getViewer($request);

        $this->initializeListViewContents($request, $viewer);
        $moduleName = 'Inventory';
        $viewer->assign('MODULE_NAME', $moduleName);
        echo $viewer->view('PopupContents.tpl', $moduleName, true);
    }

    /**
     * Function to get listView count
     * @param Vtiger_Request $request
     */
    public function getListViewCount(Vtiger_Request $request)
    {
        $moduleName = $this->getModule($request);
        $sourceModule = $request->get('src_module');
        $sourceField = $request->get('src_field');
        $sourceRecord = $request->get('src_record');
        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');
        $currencyId = $request->get('currency_id');

        $searchKey = $request->get('search_key');
        $searchValue = $request->get('search_value');

        $sourceWarehouseId = $request->get('related_parent_id');

        $listViewModel = $this->getInstanceForPopup();

        if (!empty($sourceWarehouseId)) {
            $listViewModel->set('sourceWarehouseId', $sourceWarehouseId);
        }

        if (!empty($sourceModule)) {
            $listViewModel->set('src_module', $sourceModule);
            $listViewModel->set('src_field', $sourceField);
            $listViewModel->set('src_record', $sourceRecord);
            $listViewModel->set('currency_id', $currencyId);
        }

        if (!empty($orderBy)) {
            $listViewModel->set('orderby', $orderBy);
            $listViewModel->set('sortorder', $sortOrder);
        }
        if ((!empty($searchKey)) && (!empty($searchValue))) {
            $listViewModel->set('search_key', $searchKey);
            $listViewModel->set('search_value', $searchValue);
        }
        $count = $listViewModel->getListViewCount();

        return $count;
    }

    /**
     * Function returns module name for which Popup will be initialized
     * @param type $request
     */
    public function getModule($request)
    {
        return 'Products';
    }

}
