<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouseTransfers_ProductsPopup_View extends Inventory_ProductsPopup_View
{

    public function initializeListViewContents(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        //src_module value is added to just to stop showing inactive products
        $request->set('src_module', $request->getModule());

        $moduleName = $this->getModule($request);
        $pageNumber = $request->get('page', '1');
        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');
        $sourceModule = $request->get('src_module');
        $sourceField = $request->get('src_field');
        $sourceRecord = $request->get('src_record');
        $searchKey = $request->get('search_key');
        $searchValue = $request->get('search_value');
        $currencyId = $request->get('currency_id');
        $searchParams = $request->get('search_params');
        $sourceWarehouseId = $request->get("related_parent_id");
        $getUrl = $request->get('get_url');
        $multiSelectMode = $request->get('multi_select', false);

        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set('page', $pageNumber);
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $listViewModel = $this->getInstanceForPopup();
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($moduleModel);

        if (!empty($orderBy)) {
            $listViewModel->set('orderby', $orderBy);
            $listViewModel->set('sortorder', $sortOrder);
        }
        if (!empty($sourceModule)) {
            $listViewModel->set('src_module', $sourceModule);
            $listViewModel->set('src_field', $sourceField);
            $listViewModel->set('src_record', $sourceRecord);
        }
        if (!empty($searchKey) && !empty($searchValue)) {
            $listViewModel->set('search_key', $searchKey);
            $listViewModel->set('search_value', $searchValue);
        }
        if (!empty($searchParams)) {
            $transformedSearchParams = $this->transferListSearchParamsToFilterCondition($searchParams, $listViewModel->getModule());
            $listViewModel->set('search_params', $transformedSearchParams);
        }
        if (!empty($sourceWarehouseId)) {
            $listViewModel->set('sourceWarehouseId', $sourceWarehouseId);
        }
        if (!$this->listViewHeaders) {
            $this->listViewHeaders = $listViewModel->getListViewHeaders();
        }
        if (!$this->listViewEntries && $moduleModel->isActive()) {
            $this->listViewEntries = $listViewModel->getListViewEntries($pagingModel);
        } else {
            $this->listViewEntries = array();
            $viewer->assign('IS_MODULE_DISABLED', true);
        }

        foreach ($this->listViewEntries as $key => $listViewEntry) {
            $productId = $listViewEntry->getId();
            $subProducts = $listViewModel->getSubProducts($productId);

            if ($subProducts) {
                $listViewEntry->set('subProducts', $subProducts);
            }
        }

        if (!empty($sourceWarehouseId)) {
            $viewer->assign('RELATED_PARENT_ID', $sourceWarehouseId);
        }

        $noOfEntries = ITS4YouWarehouseTransfers_Utils_Helper::count($this->listViewEntries);

        if (empty($sortOrder)) {
            $sortOrder = 'ASC';
        }
        if ('ASC' === $sortOrder) {
            $nextSortOrder = 'DESC';
            $sortImage = 'icon-chevron-down';
            $faSortImage = 'fa-sort-desc';
        } else {
            $nextSortOrder = 'ASC';
            $sortImage = 'icon-chevron-up';
            $faSortImage = 'fa-sort-asc';
        }
        if (empty($searchParams)) {
            $searchParams = array();
        }

        foreach($searchParams as $fieldListGroup){
            foreach($fieldListGroup as $fieldSearchInfo){
                $fieldSearchInfo['searchValue'] = $fieldSearchInfo[2];
                $fieldSearchInfo['fieldName'] = $fieldName = $fieldSearchInfo[0];
                $fieldSearchInfo['comparator'] = $fieldSearchInfo[1];
                $searchParams[$fieldName] = $fieldSearchInfo;
            }
        }

        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('RELATED_MODULE', $moduleName);
        $viewer->assign('SOURCE_MODULE', $sourceModule);
        $viewer->assign('SOURCE_FIELD', $sourceField);
        $viewer->assign('SOURCE_RECORD', $sourceRecord);
        $viewer->assign('SEARCH_KEY', $searchKey);
        $viewer->assign('SEARCH_VALUE', $searchValue);
        $viewer->assign('ORDER_BY', $orderBy);
        $viewer->assign('SORT_ORDER', $sortOrder);
        $viewer->assign('NEXT_SORT_ORDER', $nextSortOrder);
        $viewer->assign('SORT_IMAGE', $sortImage);
        $viewer->assign('FASORT_IMAGE',$faSortImage);
        $viewer->assign('GETURL', $getUrl);
        $viewer->assign('CURRENCY_ID', $currencyId);
        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('PAGING_MODEL', $pagingModel);
        $viewer->assign('PAGE_NUMBER', $pageNumber);
        $viewer->assign('LISTVIEW_ENTRIES_COUNT', $noOfEntries);
        $viewer->assign('LISTVIEW_HEADERS', $this->listViewHeaders);
        $viewer->assign('LISTVIEW_ENTRIES', $this->listViewEntries);
        $viewer->assign('SEARCH_DETAILS', $searchParams);

        if (PerformancePrefs::getBoolean('LISTVIEW_COMPUTE_PAGE_COUNT', false)) {
            if (!$this->listViewCount) {
                $this->listViewCount = $listViewModel->getListViewCount();
            }
            $totalCount = $this->listViewCount;
            $pageLimit = $pagingModel->getPageLimit();
            $pageCount = ceil((int)$totalCount / (int)$pageLimit);

            if ($pageCount == 0) {
                $pageCount = 1;
            }
            $viewer->assign('PAGE_COUNT', $pageCount);
            $viewer->assign('LISTVIEW_COUNT', $totalCount);
        }

        $viewer->assign('MULTI_SELECT', $multiSelectMode);
        $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('TARGET_MODULE', $moduleName);
        $viewer->assign('MODULE', $request->getModule());
        $viewer->assign('MODULE_MODEL', Vtiger_Module_Model::getInstance($request->getModule()));
        $viewer->assign('GETURL', 'getTaxesURL');
        $viewer->assign('VIEW', 'ProductsPopup');
    }

    /**
     * Function to get the Instance of Vtiger ListView model for a given module and custom view
     * @return Vtiger_ListView_Model instance
     */
    protected function getInstanceForPopup()
    {
        $db = PearDatabase::getInstance();

        $currentUser = vglobal('current_user');

        $instance = new ITS4YouWarehouseTransfers_ProductsInWarehousesListView_Model();
        $moduleModel = Vtiger_Module_Model::getInstance("Products");

        $queryGenerator = new EnhancedQueryGenerator($moduleModel->get('name'), $currentUser);

        $listFields = $moduleModel->getPopupViewFieldsList();

        $listFields[] = 'id';
        $queryGenerator->setFields($listFields);

        $controller = new ListViewController($db, $currentUser, $queryGenerator);

        return $instance->set('module', $moduleModel)->set('query_generator', $queryGenerator)->set('listview_controller', $controller);
    }

}
