<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouseTransfers_Record_Model extends ITS4YouWarehouses_InventoryRecord_Model
{

    public function getProducts()
    {
        $relatedProducts = parent::getProducts();
        $productsCount = ITS4YouWarehouseTransfers_Utils_Helper::count($relatedProducts);

        if ($this->get("fromwarehouseid") > 0 && $productsCount > 0) {
            $warehouseRecordModel = Vtiger_Record_Model::getInstanceById($this->get("fromwarehouseid"), "ITS4YouWarehouses");
            for ($i = 1; $i <= $productsCount; $i++) {
                $relatedProducts[$i]["qtyInStock" . $i] = $warehouseRecordModel->getProductQtyInStock($relatedProducts[$i]["hdnProductId" . $i]);
            }
        }

        return $relatedProducts;
    }

}
