<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ProductsInWarehousesListView
 *
 * @author zavad
 */
class ITS4YouWarehouseTransfers_ProductsInWarehousesListView_Model extends Products_ListView_Model
{

    public function getQuery()
    {
        $queryGenerator = $this->get('query_generator');

        $listQuery = $queryGenerator->getQuery();
        if ($this->has("sourceWarehouseId")) {
            $listQuery = strtolower($listQuery);

            //replace vtiger_products.qtyinstock with the relevant one from table its4you_warehouses_productrel        
            $pattern = "/vtiger_products.qtyinstock/";
            $replacement = "CASE WHEN its4you_warehouses_productrel.quantity != '' THEN its4you_warehouses_productrel.quantity ELSE 0 END AS qtyinstock";
            $listQuery = preg_replace($pattern, $replacement, $listQuery, 1);

            //replace others occurecences of vtiger_products.qtyinstock for possible searching
            //replace dummy vtiger_products.qtyinstock with the relevant one from table its4you_warehouses_productrel        
            $pattern = "/vtiger_products.qtyinstock/";
            $replacement = "its4you_warehouses_productrel.quantity";
            $listQuery = preg_replace($pattern, $replacement, $listQuery);

            //add left join to its4you_warehouses_productrel table            
            $pattern = "/from vtiger_products/";
            $replacement = "from vtiger_products LEFT JOIN its4you_warehouses_productrel ON vtiger_products.productid = its4you_warehouses_productrel.productid 
                                                AND its4you_warehouses_productrel.warehouseid = " . $this->get("sourceWarehouseId");
            $listQuery = preg_replace($pattern, $replacement, $listQuery, 1);

            //adjust where condition so only products on source warehouse are selected 
            //or all products if warehouse has negative quantity allowed
            $listQuery .= ' AND its4you_warehouses_productrel.quantity > 0 ';
        }
        return $listQuery;
    }

}
