<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouseTransfers extends CRMEntity
{

    public $log;
    public $db;
    public $table_name = "its4you_warehousetransfers";
    public $table_index = 'warehousetransferid';
    public $module_name = 'ITS4YouWarehouseTransfers';
    public $moduleName = 'ITS4YouWarehouseTransfers';

    /**
     * Mandatory table for supporting custom fields.
     */
    public $customFieldTable = Array('its4you_warehousetransferscf', 'warehousetransferid');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    public $tab_name = Array('vtiger_crmentity', 'its4you_warehousetransfers', 'its4you_warehousetransferscf', 'vtiger_inventoryproductrel');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    public $tab_name_index = Array(
        'vtiger_crmentity' => 'crmid',
        'its4you_warehousetransfers' => 'warehousetransferid',
        'its4you_warehousetransferscf' => 'warehousetransferid',
        'vtiger_inventoryproductrel' => 'id'
    );

    /**
     * Mandatory for Listing (Related listview)
     */
    public $list_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        /* tablename should not have prefix 'vtiger_' */
        'Warehouse Transfer No' => Array('warehousetransfers' => 'warehousetransfer_no'),
        'Subject' => Array('warehousetransfers' => 'subject'),
        'FromWarehouse' => Array('warehousetransfers' => 'fromwarehouseid'),
        'ToWarehouse' => Array('warehousetransfers' => 'towarehouseid'),
        'Status' => Array('warehousetransfers' => 'wtstatus')
    );
    public $list_fields_name = Array(
        /* Format: Field Label => fieldname */
        'Warehouse Transfer No' => 'warehousetransfer_no',
        'Subject' => 'subject',
        'FromWarehouse' => 'fromwarehouseid',
        'ToWarehouse' => 'towarehouseid',
        'Status' => 'wtstatus',
        'Assigned To' => 'assigned_user_id'
    );
    /* Make the field link to detail view from list view (Fieldname) */
    public $list_link_field = 'subject';
    /* For Popup listview and UI type support */
    public $search_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        /* tablename should not have prefix 'vtiger_' */
        'Warehouse Transfer No' => Array('warehousetransfers', 'warehousetransfer_no'),
        'Subject' => Array('warehousetransfers', 'subject'),
    );
    public $search_fields_name = Array(
        /* Format: Field Label => fieldname */
        'Warehouse Transfer No' => 'warehousetransfer_no',
        'Subject' => 'subject'
    );
    // For Popup window record selection
    public $popup_fields = Array('warehousetransfer_no', 'subject');
    // For Alphabetical search
    public $def_basicsearch_col = 'subject';
    // Column value to use on detail view record text display
    public $def_detailview_recname = 'warehousetransfer_no';
    // Used when enabling/disabling the mandatory fields for the module.
    // Refers to vtiger_field.fieldname values.
    public $mandatory_fields = Array('subject', 'vendor_id', 'createdtime', 'modifiedtime');
    // Callback function list during Importing
    public $default_order_by = 'subject';
    public $default_sort_order = 'ASC';
    // For workflows update field tasks is deleted all the lineitems.
    public $isLineItemUpdate = true;
    // This is used to retrieve related vtiger_fields from form posts.
    public $additional_column_fields = Array('assigned_user_name', 'smownerid', 'currency_id');
    public $column_fields;
    public $parentName = 'Inventory';

    public function __construct()
    {
        global $log;

        $this->log = $log;
        $this->db = PearDatabase::getInstance();
        $this->column_fields = getColumnFields($this->module_name);
    }

    public function insertIntoEntityTable($table_name, $module, $fileid = '')
    {
        //Ignore relation table insertions while saving of the record
        if ($table_name == 'vtiger_inventoryproductrel') {
            return;
        }
        parent::insertIntoEntityTable($table_name, $module, $fileid);
    }

    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
     */
    public function vtlib_handler($modulename, $event_type)
    {
        require_once 'vtlib/Vtiger/Module.php';
        require_once 'modules/ModTracker/ModTracker.php';
        require_once 'modules/ModComments/ModComments.php';

        switch ($event_type) {
            case 'module.enabled':
            case 'module.postupdate':
            case 'module.postinstall':
                $this->addCustomLinks();
                break;
            case 'module.preupdate':
            case 'module.preuninstall':
            case 'module.disabled':
                $this->deleteCustomLinks();
                break;
        }
    }

    public function updateNumbering()
    {
        $this->setModuleSeqNumber('configure', $this->moduleName, 'WT', 1);
        $this->updateMissingSeqNumber($this->moduleName);
    }

    public function addCustomLinks()
    {
        $this->updateNumbering();
        $this->updateRelatedList();
        $this->updateFields();

        Settings_MenuEditor_Module_Model::addModuleToApp($this->moduleName, $this->parentName);
        ModComments::addWidgetTo([$this->moduleName]);
        ModTracker::enableTrackingForModule(getTabid($this->moduleName));
    }

    public function updateFields()
    {
        $this->db->pquery('UPDATE vtiger_field SET typeofdata=? WHERE columnname=? AND tablename=?; ', ['D~M', 'duedate', 'its4you_warehousetransfers']);
        $this->db->pquery('DELETE FROM vtiger_field WHERE fieldname=? AND tablename=?; ', ['carrier', 'its4you_warehousetransfers']);

        $this->updateItemDetailFields();
    }

    public function updateItemDetailFields()
    {
        $fieldNames = array('txtAdjustment', 'hdnSubTotal', 'hdnGrandTotal', 'hdnDiscountAmount', 'hdnS_H_Amount', 'pre_tax_total');
        $this->db->pquery('UPDATE vtiger_field SET uitype=? WHERE tabid=? AND fieldname IN(' . generateQuestionMarks($fieldNames) . ')',
            array(72, getTabid($this->moduleName), $fieldNames)
        );
    }

    public function deleteCustomLinks()
    {
        $this->updateRelatedList(false);

        ModComments::removeWidgetFrom([$this->moduleName]);
        ModTracker::disableTrackingForModule(getTabid($this->moduleName));
    }

    /**
     * @var array
     * [module, related module, relate label, related actions, related function]
     * $moduleInstance->setRelatedList($relatedListModule, $relatedLabel, $relatedActions, $relatedFunction);
     */
    public $registerRelatedLists = [
        ['ITS4YouWarehouseTransfers', 'ITS4YouReceiptcards'],
        ['ITS4YouWarehouseTransfers', 'Documents', 'Documents', 'ADD,SELECT', 'get_attachments'],
        ['ITS4YouReceiptcards', 'ITS4YouWarehouseTransfers'],
        ['ITS4YouWarehouses', 'ITS4YouWarehouseTransfers', 'ITS4YouWarehouseTransfers', '', 'get_warehousetransfers'],
        ['Products', 'ITS4YouWarehouseTransfers', 'ITS4YouWarehouseTransfers'],
    ];

    /**
     * @param bool $register
     */
    public function updateRelatedList($register = true)
    {
        foreach ($this->registerRelatedLists as $relatedList) {
            $module = Vtiger_Module::getInstance($relatedList[0]);
            $relatedModule = Vtiger_Module::getInstance($relatedList[1]);

            if ($module && $relatedModule) {
                $relatedLabel = isset($relatedList[2]) ? $relatedList[2] : $relatedModule->name;
                $relatedActions = isset($relatedList[3]) ? $relatedList[3] : '';
                $relatedFunction = isset($relatedList[4]) ? $relatedList[4] : 'get_related_list';
                $field = isset($relatedList[5]) ? Vtiger_Field_Model::getInstance($relatedList[5], $relatedModule) : '';
                $fieldId = $field ? $field->getId() : '';

                $module->unsetRelatedList($relatedModule, $relatedLabel);
                $module->unsetRelatedList($relatedModule, $relatedLabel, $relatedFunction);

                if ($register) {
                    $module->setRelatedList($relatedModule, $relatedLabel, $relatedActions, $relatedFunction, $fieldId);
                }
            }
        }
    }


    /**
     * @throws AppException
     */
    public function save_module($module)
    {
        //in ajax save we should not call this function, because this will delete all the existing product values
        if (isset($_REQUEST['totalProductCount'])) {
            if ($_REQUEST['action'] != 'ITS4YouWarehouseTransfersAjax' && (!isset($_REQUEST['ajxaction']) || $_REQUEST['ajxaction'] != 'DETAILVIEW') && $_REQUEST['action'] != 'MassEditSave' && (!isset($_REQUEST['mycrmode']) || $_REQUEST['mycrmode'] != 'AutoCreate')) { // ITS4YOU-UP SlOl 
                ITS4YouWarehouses_InventoryUtils_Helper::saveParentInventoryProducts($this);
            }
        }

        // Update the currency id and the conversion rate for the internal productmoves // update status manually because of displaytype
        $this->updateItemDetails();

        // create relationship between WT and related modules RC in case of ReturnProducts
        if (isset($_REQUEST['parent_id']) && !empty($_REQUEST['parent_id'])) {
            $this->createRelationFromRecord(vtlib_purify($_REQUEST['parent_id']));
        }
    }

    /**
     * @throws AppException
     */
    public function createRelationFromRecord($recordId)
    {
        $module = Vtiger_Module_Model::getInstance('ITS4YouWarehouseTransfers');
        $parentModuleName = getSalesEntityType($recordId);
        $parentModule = Vtiger_Module_Model::getInstance($parentModuleName);

        if ($parentModule) {
            $relationModel = Vtiger_Relation_Model::getInstance($parentModule, $module);

            if ($relationModel) {
                $relationModel->addRelation($recordId, $this->id);
            } else {
                throw new AppException('Warehouse Transfers relation does not exists for parent: ' . $parentModuleName);
            }
        }
    }

    public function updateItemDetails()
    {
        $data = $this->column_fields;
        $params = array(
            'currency_id' => $data['currency_id'],
            'conversion_rate' => $data['conversion_rate'],
        );

        if (!empty($data['wtstatus'])) {
            $params['wtstatus'] = $data['wtstatus'];
        }

        $query = sprintf('UPDATE %s SET %s=? where %s=?', $this->table_name, implode('=?,', array_keys($params)), $this->table_index);
        $this->db->pquery($query, [$params, $this->id]);
    }

}
