<?php
/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_ProductsPopup_View extends Inventory_ProductsPopup_View
{
    /**
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     */
    public function initializeListViewContents(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        parent::initializeListViewContents($request, $viewer);

        if (!empty($request->get('related_parent_id'))) {
            $warehouseRecordModel = Vtiger_Record_Model::getInstanceById($request->get("related_parent_id"));
            /* @var $warehouseRecordModel ITS4YouWarehouses_Record_Model */

            foreach ($this->listViewEntries as $recordModel) {
                /* @var $recordModel Products_Record_Model */
                $recordModel->set("qtyinstock", ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($warehouseRecordModel->getProductQtyInStock($recordModel->getId())));
            }
            $viewer->assign('LISTVIEW_ENTRIES', $this->listViewEntries);
            $viewer->assign('RELATED_PARENT_ID', $request->get("related_parent_id"));
        }
    }

}
