<?php

/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_Preferences_View extends Vtiger_Index_View
{
    /**
     * @param Vtiger_Request $request
     * @return mixed
     */
    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();
        unset($headerScriptInstances["modules.$moduleName.resources.Edit"]);

        return $headerScriptInstances;
    }

    /**
     * @param Vtiger_Request $request
     * @param bool $display
     * @return bool|void
     */
    public function preProcess(Vtiger_Request $request, $display = true)
    {
        $moduleModel = new ITS4YouWHDeliveryNotes_Module_Model();
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $viewer->assign('QUALIFIED_MODULE', $moduleName);
        Vtiger_Basic_View::preProcess($request, false);
        $linkParams = array('MODULE' => $moduleName, 'ACTION' => $request->get('view'));
        $linkModels = $moduleModel->getSideBarLinks($linkParams);
        $viewer->assign('QUICK_LINKS', $linkModels);
        $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('CURRENT_VIEW', $request->get('view'));

        if ($display) {
            $this->preProcessDisplay($request);
        }
    }

    /**
     * @param Vtiger_Request $request
     */
    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);

        switch ($request->get('mode')) {
            case 'edit':
                $viewer->assign('VIEWMODEL', $this->getViewModel());
                $viewer->view('PreferencesEdit.tpl', 'ITS4YouWHDeliveryNotes');
                break;
            case 'save':
                $this->savePreferences($request);
                $viewer->assign('MESSAGE', vtranslate('LBL_PREFERENCES_SAVED', 'ITS4YouWHDeliveryNotes'));
                $viewer->assign('VIEWMODEL', $this->getViewModel());
                $viewer->view('Preferences.tpl', 'ITS4YouWHDeliveryNotes');
                break;
            default:    // detail
                $viewer->assign('VIEWMODEL', $this->getViewModel());
                $viewer->view('Preferences.tpl', 'ITS4YouWHDeliveryNotes');
        }
    }

    /**
     * @return array
     */
    private function getViewModel()
    {
        return array('preferences' => ITS4YouWHDeliveryNotes_Preferences_Model::loadAll());
    }

    /**
     * @param Vtiger_Request $request
     */
    private function savePreferences(Vtiger_Request $request)
    {
        $preferenceInstances = ITS4YouWHDeliveryNotes_Preferences_Model::loadAll();

        foreach ($preferenceInstances as $preferenceInstance) {
            /* @var $preferenceInstance ITS4YouWHDeliveryNotes_Preferences_Model */
            $preferenceInstance->setEditViewValue($request->get($preferenceInstance->getName()));
            $preferenceInstance->save($request);
        }
    }

}
