<?php
/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_IndexAjax_View extends Vtiger_IndexAjax_View
{

    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('showSettingsList');
        $this->exposeMethod('editLicense');
    }

    public function showSettingsList(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();

        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);

        $viewer->assign('MODULE', $moduleName);

        $linkParams = array('MODULE' => $moduleName, 'ACTION' => $request->get('view'), 'MODE' => $request->get('mode'));
        $linkModels = $moduleModel->getSideBarLinks($linkParams);
        $viewer->assign('QUICK_LINKS', $linkModels);

        $parent_view = $request->get('pview');

        //if ($parent_view == "EditProductBlock") $parent_view = "ProductBlocks";

        $viewer->assign('CURRENT_PVIEW', $parent_view);

        echo $viewer->view('SettingsList.tpl', 'ITS4YouWHDeliveryNotes', true);
    }

    public function editLicense(Vtiger_Request $request)
    {
        $moduleModel = new ITS4YouWHDeliveryNotes_Module_Model();

        $viewer = $this->getViewer($request);

        $moduleName = $request->getModule();

        $type = $request->get('type');
        $viewer->assign("TYPE", $type);

        $key = $request->get('key');
        $viewer->assign("LICENSEKEY", $key);

        $viewer->assign('MODULE', $moduleName);

        echo $viewer->view('EditLicense.tpl', 'ITS4YouWHDeliveryNotes', true);
    }
}