<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_CustomPOEdit_View extends Inventory_Edit_View
{

    public function preProcess(Vtiger_Request $request, $display = true)
    {
        $request->set("module", "PurchaseOrder"); //forcing MODULE to be Purchase Order
        $request->set("view", "Edit");      //forcing VIEW to appear as Edit view of Purchase because of JavaScript events registration in app.js::getPageController

        parent::preProcess($request, $display);
    }

    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
//        $record = $request->get('record');
        $sourceRecord = $request->get('sourceRecord');
        $sourceModule = $request->get('sourceModule');

        $parentRecordModel = Inventory_Record_Model::getInstanceById($sourceRecord);
        $currencyInfo = $parentRecordModel->getCurrencyInfo();

        $shippingTaxes = $parentRecordModel->getShippingTaxes();
        $recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);
        $recordModel->setRecordFieldValues($parentRecordModel);

        $settingsModel = Settings_Vtiger_CompanyDetails_Model::getInstance();
        $recordModel->set('bill_street', $settingsModel->get('address'));
        $recordModel->set('ship_street', $settingsModel->get('address'));
        $recordModel->set('bill_city', $settingsModel->get('city'));
        $recordModel->set('ship_city', $settingsModel->get('city'));
        $recordModel->set('bill_state', $settingsModel->get('state'));
        $recordModel->set('ship_state', $settingsModel->get('state'));
        $recordModel->set('bill_code', $settingsModel->get('code'));
        $recordModel->set('ship_code', $settingsModel->get('code'));
        $recordModel->set('bill_country', $settingsModel->get('country'));
        $recordModel->set('ship_country', $settingsModel->get('country'));
        $recordModel->set('postatus', 'Created');
        $recordModel->set('currency_id', $parentRecordModel->get('currency_id'));
        $recordModel->set('conversion_rate', $parentRecordModel->get('conversion_rate'));
        $recordModel->set('region_id', $parentRecordModel->get('region_id'));
        $recordModel->set('hdnTaxType', $parentRecordModel->get('hdnTaxType'));

        switch ($sourceModule) {
            case "SalesOrder":
                $recordModel->set("subject", $parentRecordModel->get("subject"));
                $recordModel->set("carrier", $parentRecordModel->get("carrier"));
                break;

            case "Invoice":
                $recordModel->set("subject", $parentRecordModel->get("subject"));
                break;

            default:
                throw new Exception("ITS4YouWHDeliveryNotes :: Unsupported source module.");
        }
        //relevant products   
        $lineItems = unserialize(Vtiger_Session::get("lineItemsWithoutVendor"));
        $relatedProducts = ITS4YouWarehouses_InventoryUtils_Helper::getAssociatedProductsModified($parentRecordModel->getEntity(), $lineItems);

        //  indexing fix  
        $filteredIdx = 1;
        $filteredRelatedProducts = array();
        $lineItemIDs = array();
        foreach ($relatedProducts as $idx => $prodData) {
            foreach ($prodData as $key => $val) {
                $filteredKey = ITS4YouWarehouses_Products_Helper::fixFieldIndex($filteredIdx, $key);

                if ($key != "final_details" || $filteredIdx == 1) {
                    if (strpos($key, "lineItemId") !== false) {
                        $lineItemIDs[$filteredIdx] = $val;
                    }
                    $filteredRelatedProducts[$filteredIdx][$filteredKey] = $val;
                }
            }
            $filteredIdx++;
        }

        $relatedProducts = $filteredRelatedProducts;
        $moduleModel = $recordModel->getModule();
        $fieldList = $moduleModel->getFields();
        $requestFieldList = array_intersect_key($request->getAll(), $fieldList);

        //get the inventory terms and conditions
        $inventoryRecordModel = Inventory_Record_Model::getCleanInstance($moduleName);
        $termsAndConditions = $inventoryRecordModel->getInventoryTermsandConditions();

        foreach ($requestFieldList as $fieldName => $fieldValue) {
            $fieldModel = $fieldList[$fieldName];
            if ($fieldModel->isEditable()) {
                $recordModel->set($fieldName, $fieldModel->getDBInsertValue($fieldValue));
            }
        }
        //needed to override balance from Invoice
        $recordModel->set("balance", 0);

        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);

        $viewer->assign('LINE_ITEM_IDS', Zend_Json::encode($lineItemIDs));
        $viewer->assign('SOURCE_MODULE', $sourceModule);
        $viewer->assign('SOURCE_RECORD', $sourceRecord);
        $viewer->assign('VIEW_MODE', "fullForm");
        $viewer->assign('IS_RELATION_OPERATION', false);
        $viewer->assign('IS_DUPLICATE', false);
        $currencies = Inventory_Module_Model::getAllCurrencies();
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);

        $viewer->assign('PICKIST_DEPENDENCY_DATASOURCE', Zend_Json::encode($picklistDependencyDatasource));
        $viewer->assign('RECORD', $recordModel);
        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('CURRENTDATE', date('Y-n-j'));
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());

        $viewer->assign('RELATED_PRODUCTS', $relatedProducts);
        $viewer->assign('SHIPPING_TAXES', $shippingTaxes);
        $viewer->assign('TAXES', $relatedProducts[1]["final_details"]["taxes"]);
        $viewer->assign('CURRENCINFO', $currencyInfo);
        $viewer->assign('CURRENCIES', $currencies);
        $viewer->assign('TERMSANDCONDITIONS', $termsAndConditions);

        $viewer->assign('PRODUCT_ACTIVE', true);
        $viewer->assign('SERVICE_ACTIVE', false);

        $taxType = $recordModel->get('hdnTaxType');
        $taxRegions = $recordModel->getRegionsList();
        $defaultRegionInfo = $taxRegions[0];
        unset($taxRegions[0]);

        $viewer->assign('TAX_REGIONS', $taxRegions);
        $viewer->assign('DEFAULT_TAX_REGION_INFO', $defaultRegionInfo);
        $viewer->assign('TAX_TYPE', $taxType);

        $viewer->view('CustomPOEditView.tpl', 'ITS4YouWHDeliveryNotes');
    }

}
