<?php
/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_CustomInvoiceEdit_View extends Invoice_Edit_View
{

    public function preProcess(Vtiger_Request $request, $display = true)
    {
        $request->set('module', 'Invoice'); //forcing MODULE to be Invoice
        $request->set('view', 'Edit');      //forcing VIEW to appear as Edit view of Invoice because of JavaScript events registration in app.js::getPageController

        parent::preProcess($request, $display);
    }

    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $record = $request->get('record');
        $sourceRecord = $request->get('sourceRecord');
        $sourceModule = $request->get('sourceModule');
        $parentRecordModel = Inventory_Record_Model::getInstanceById($sourceRecord);
        $currencyInfo = $parentRecordModel->getCurrencyInfo();
        $taxes = $parentRecordModel->getProductTaxes();
        $shippingTaxes = $parentRecordModel->getShippingTaxes();
        /** @var $recordModel Inventory_Record_Model */
        $recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);
        $recordModel->setRecordFieldValues($parentRecordModel);

        switch ($sourceModule) {
            case 'SalesOrder':
                if(!empty($sourceRecord) && isRecordExists($sourceRecord)) {
                    $recordModel->set('salesorder_id', $sourceRecord);
                }

                $deliveryNoteIDs = $request->get('deliveryNoteIDs');
                break;
            case 'ITS4YouWHDeliveryNotes':
                $deliveryNoteIDs = array($sourceRecord);

                if (!empty($parentRecordModel->get('referenceid')) && isRecordExists($parentRecordModel->get('referenceid'))) {
                    $recordModel->set('salesorder_id', $parentRecordModel->get('referenceid'));
                }
                $recordModel->set('subject', $parentRecordModel->get('deliverynotes_no'));
                $orgaRecordModel = Vtiger_Record_Model::getInstanceById($parentRecordModel->get('parent_id'));

                if ('Accounts' === $orgaRecordModel->getModuleName()) {
                    $recordModel->set('account_id', $orgaRecordModel->get('id'));
                    $recordModel->set('bill_street', $orgaRecordModel->get('bill_street'));
                    $recordModel->set('bill_city', $orgaRecordModel->get('bill_city'));
                    $recordModel->set('bill_state', $orgaRecordModel->get('bill_state'));
                    $recordModel->set('bill_code', $orgaRecordModel->get('bill_code'));
                    $recordModel->set('bill_country', $orgaRecordModel->get('bill_country'));
                    $recordModel->set('bill_pobox', $orgaRecordModel->get('bill_pobox'));
                }
                break;

            default:
                throw new Exception('ITS4YouWHDeliveryNotes :: Unsupported source module.');
        }
        //relevant products
        $relatedProducts = array();

        foreach ($deliveryNoteIDs as $deliveryNoteID) {
            $dnRecordModel = ITS4YouWHDeliveryNotes_Record_Model::getInstanceById($deliveryNoteID, 'ITS4YouWHDeliveryNotes');
            /* @var $dnRecordModel Inventory_Record_Model */
            $dnProducts = $dnRecordModel->getProducts();
            //add information about product origin (DN) to product comment
            $newComment = vtranslate('ITS4YouWHDeliveryNotes', 'ITS4YouWHDeliveryNotes') . ': ' . $dnRecordModel->get('deliverynotes_no');
            $dnActionBlock = ITS4YouWarehouses_Base_ActionBlock::factory('ITS4YouWHDeliveryNotes', $deliveryNoteID);
            $toBeInvoicedLineItems = $dnActionBlock->getLineItems();

            for ($j = 1; $j <= count($dnProducts); $j++) {
                $originalComment = $dnProducts[$j]['comment' . $j];
                $dnProducts[$j]['comment' . $j] = ($originalComment == '' ? $newComment : $newComment . "\n" . $originalComment);
                //adjust quantity
                $lineItemId = $dnProducts[$j]['lineItemId' . $j];

                if (isset($toBeInvoicedLineItems[$lineItemId])) {
                    $toBeInvoicedLineItem = $toBeInvoicedLineItems[$lineItemId];
                    /* @var $toBeInvoicedLineItem ITS4YouWarehouses_InventoryLineItem_Helper */
                    $qty = $toBeInvoicedLineItem->getAdjustedQuantity();
                    $listPrice = $toBeInvoicedLineItem->getPrice();
                    //calculate productTotal
                    $productTotal = $qty * $listPrice;
                    $dnProducts[$j]['qty' . $j] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($qty);
                    $dnProducts[$j]['listPrice' . $j] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($listPrice);
                    $dnProducts[$j]['productTotal' . $j] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($productTotal);
                    $discountType = $toBeInvoicedLineItem->getDiscountType();

                    switch ($discountType) {
                        case 'percentage':
                            $discountTotal = $productTotal * $toBeInvoicedLineItem->getDiscountPercent() / 100;
                            $dnProducts[$j]['discount_type' . $j] = $discountType;
                            $dnProducts[$j]['discount_percent' . $j] = $toBeInvoicedLineItem->getDiscountPercent();
                            $dnProducts[$j]['checked_discount_percent' . $j] = ' checked';
                            break;

                        case 'amount':
                            $discountTotal = $toBeInvoicedLineItem->getDiscountAmount();
                            $dnProducts[$j]['discount_type' . $j] = $discountType;
                            $dnProducts[$j]['discount_amount' . $j] = $toBeInvoicedLineItem->getDiscountAmount();
                            $dnProducts[$j]['checked_discount_amount' . $j] = ' checked';
                            break;

                        default:
                            $discountTotal = 0;
                            break;
                    }

                    $totalAfterDiscount = $productTotal - $discountTotal;
                    $dnProducts[$j]['discountTotal' . $j] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($discountTotal);
                    $dnProducts[$j]['totalAfterDiscount' . $j] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($totalAfterDiscount);
                    $dnProducts[$j]['netPrice' . $j] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($totalAfterDiscount);
                } else {
                    unset($dnProducts[$j]);
                }
            }

            $relatedProducts = array_merge($relatedProducts, $dnProducts);
        }
        //  indexing fix
        $filteredIdx = 1;
        $filteredRelatedProducts = array();
        $lineItemIDs = array();

        foreach ($relatedProducts as $idx => $prodData) {

            foreach ($prodData as $key => $val) {
                $filteredKey = ITS4YouWarehouses_Products_Helper::fixFieldIndex($filteredIdx, $key);

                if ('final_details' != $key || 1 == $filteredIdx) {

                    if (strpos($key, 'lineItemId')) {
                        $lineItemIDs[$filteredIdx] = $val;
                    }
                    $filteredRelatedProducts[$filteredIdx][$filteredKey] = $val;
                }
            }
            $filteredIdx++;
        }

        $filteredRelatedProducts[1]['taxes'] = $recordModel->getProducts()[1]['taxes'];
        $relatedProducts = ITS4YouWarehouses_InventoryUtils_Helper::adjustFinalDetails($filteredRelatedProducts);
        $moduleModel = $recordModel->getModule();
        $fieldList = $moduleModel->getFields();
        $requestFieldList = array_intersect_key($request->getAll(), $fieldList);

        //get the inventory terms and conditions
        $inventoryRecordModel = Inventory_Record_Model::getCleanInstance($moduleName);
        $termsAndConditions = $inventoryRecordModel->getInventoryTermsandConditions();

        foreach ($requestFieldList as $fieldName => $fieldValue) {
            $fieldModel = $fieldList[$fieldName];
            if ($fieldModel->isEditable()) {
                $recordModel->set($fieldName, $fieldModel->getDBInsertValue($fieldValue));
            }
        }
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);

        $deductTaxes = $relatedProducts[1]['final_details']['deductTaxes'];

        if (!$deductTaxes) {
            $deductTaxes = Inventory_TaxRecord_Model::getDeductTaxesList();
        }

        $taxType = $relatedProducts[1]['final_details']['taxtype'];

        $taxRegions = $recordModel->getRegionsList();

        $defaultRegionInfo = $taxRegions[0];
        unset($taxRegions[0]);

        $viewer->assign('DEDUCTED_TAXES', $deductTaxes);
        $viewer->assign('TAX_TYPE', $taxType);
        $viewer->assign('INVENTORY_CHARGES', Inventory_Charges_Model::getInventoryCharges());
        $viewer->assign('TAX_REGIONS', $taxRegions);
        $viewer->assign('DEFAULT_TAX_REGION_INFO', $defaultRegionInfo);

        $viewer->assign('LINE_ITEM_IDS', Zend_Json::encode($lineItemIDs));
        $viewer->assign('DELIVERY_NOTE_IDS', Zend_Json::encode($deliveryNoteIDs));
        $viewer->assign('VIEW_MODE', "fullForm");
        $viewer->assign('IS_RELATION_OPERATION', false);
        $viewer->assign('IS_DUPLICATE', false);
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);

        $viewer->assign('PICKIST_DEPENDENCY_DATASOURCE', Zend_Json::encode($picklistDependencyDatasource));
        $viewer->assign('RECORD', $recordModel);
        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('CURRENTDATE', date('Y-n-j'));
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('RELATED_PRODUCTS', $relatedProducts);
        $viewer->assign('SHIPPING_TAXES', $shippingTaxes);
        $viewer->assign('TAXES', $taxes);
        $viewer->assign('CURRENCINFO', $currencyInfo);
        $viewer->assign('CURRENCIES', Inventory_Module_Model::getAllCurrencies());
        $viewer->assign('TERMSANDCONDITIONS', $termsAndConditions);
        $viewer->assign('PRODUCT_ACTIVE', Vtiger_Module_Model::getInstance('Products')->isActive());
        $viewer->assign('SERVICE_ACTIVE', Vtiger_Module_Model::getInstance('Services')->isActive());

        $viewer->view('CustomInvoiceEditView.tpl', 'ITS4YouWHDeliveryNotes');
    }

}
