<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_CreateDNFromIC_View extends Inventory_Edit_View
{

    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $jsFileNames = array(
            'modules.ITS4YouWHDeliveryNotes.resources.CreateDNFromIC',
        );
        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    public function process(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $viewer = $this->getViewer($request);
        $sourceRecord = $request->get("sourceRecord");
        $sourceModule = $request->get("sourceModule");

        //handle issuecards
        //related Products
        $itemIdx = 1;
        $relatedProducts = array();
        $warehouseRecordModels = array();
        $productRecordModels = array();

        foreach ($sourceRecord as $recordId) {
            $ICRecordModel = Inventory_Record_Model::getInstanceById($recordId);
            /* @var $ICRecordModel Inventory_Record_Model */

            $warehouseId = $ICRecordModel->get("warehouseid");
            if (!isset($warehouseRecordModels[$warehouseId])) {
                $warehouseRecordModels[$warehouseId] = Vtiger_Record_Model::getInstanceById($warehouseId);
            }
            $warehouseRecordModel = $warehouseRecordModels[$warehouseId];

            $ICProducts = $ICRecordModel->getProducts();
            $ICProductsCount = count($ICProducts);
            for ($i = 1; $i <= $ICProductsCount; $i++) {
                $productId = $ICProducts[$i]["hdnProductId" . $i];
                $quantity = $ICProducts[$i]["qty" . $i];

                if (!isset($productRecordModels[$productId])) {
                    $productRecordModels[$productId] = Vtiger_Record_Model::getInstanceById($productId, "Products");
                }
                $productRecordModel = $productRecordModels[$productId];
                /* @var $productRecordModel Products_Record_Model */

                $relatedProducts[$itemIdx]["hdnProductId" . $itemIdx] = $productId;
                $relatedProducts[$itemIdx]["productName" . $itemIdx] = $productRecordModel->getName();
                $relatedProducts[$itemIdx]["comment" . $itemIdx] = $ICProducts[$i]["comment" . $i];
                $relatedProducts[$itemIdx]["subproduct_ids" . $itemIdx] = $ICProducts[$i]["subproduct_ids" . $i];
                $relatedProducts[$itemIdx]["subprod_names" . $itemIdx] = $ICProducts[$i]["subprod_names" . $i];

                //common warehouse related - distribution data
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["qty"] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($quantity);
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["hdnWarehouseId"] = $warehouseId;
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["warehouseName"] = $warehouseRecordModel->getName();
                $productQtyInStock = $warehouseRecordModel->getProductQtyInStock($productId);
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["qtyInStockRaw"] = $productQtyInStock;
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["qtyInStock"] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($productQtyInStock);
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["hdnIssuecardId"] = $ICRecordModel->getId();
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["issuecardName"] = $ICRecordModel->getName();
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["issuecardurl"] = $ICRecordModel->getDetailViewUrl();

                $relatedProducts[$itemIdx]["totalDistributedQty" . $itemIdx] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($quantity);
                $itemIdx++;
            }
        }

        $parentRecordModel = $ICRecordModel;
        $recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);

        $recordModel->set("currency_id", $parentRecordModel->get("currency_id"));
        $recordModel->set("conversion_rate", $parentRecordModel->get("conversion_rate"));
        $recordModel->set("deliverynotetype", "Sale");

        $currencyInfo = $parentRecordModel->getCurrencyInfo();
        $taxes = $parentRecordModel->getProductTaxes();
        $shippingTaxes = $parentRecordModel->getShippingTaxes();

        //general Edit.php part
        $moduleModel = $recordModel->getModule();
        $fieldList = $moduleModel->getFields();
        $requestFieldList = array_intersect_key($request->getAll(), $fieldList);

        //get the inventory terms and conditions
        $inventoryRecordModel = Inventory_Record_Model::getCleanInstance($moduleName);
        $termsAndConditions = $inventoryRecordModel->getInventoryTermsandConditions();

        foreach ($requestFieldList as $fieldName => $fieldValue) {
            $fieldModel = $fieldList[$fieldName];
            if ($fieldModel->isEditable()) {
                $recordModel->set($fieldName, $fieldModel->getDBInsertValue($fieldValue));
            }
        }
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);

        $viewer->assign('VIEW_MODE', "fullForm");
        //if it is relation edit
        $isRelationOperation = $request->get('relationOperation');
        $viewer->assign('IS_RELATION_OPERATION', $isRelationOperation);
        if ($isRelationOperation) {
            $viewer->assign('SOURCE_MODULE', $sourceModule);
            $viewer->assign('SOURCE_RECORD', $sourceRecord);
        }

        $viewer->assign('IS_DUPLICATE', false);
        $currencies = Inventory_Module_Model::getAllCurrencies();
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);

        $viewer->assign('PICKIST_DEPENDENCY_DATASOURCE', Zend_Json::encode($picklistDependencyDatasource));
        $viewer->assign('RECORD', $recordModel);
        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('CURRENTDATE', date('Y-n-j'));
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());

        $viewer->assign('RELATED_PRODUCTS', $relatedProducts);
        $viewer->assign('SHIPPING_TAXES', $shippingTaxes);
        $viewer->assign('TAXES', $taxes);
        $viewer->assign('CURRENCINFO', $currencyInfo);
        $viewer->assign('CURRENCIES', $currencies);
        $viewer->assign('TERMSANDCONDITIONS', $termsAndConditions);

//        $productModuleModel = Vtiger_Module_Model::getInstance('Products');
        $viewer->assign('PRODUCT_ACTIVE', false);
        $viewer->assign('SERVICE_ACTIVE', false);
        $viewer->view('EditView.tpl', $moduleName);
    }

}
