<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_AvailableSave_View extends ITS4YouWHDeliveryNotes_Edit_View
{

    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $jsFileNames = array(
            'modules.ITS4YouWHDeliveryNotes.resources.AvailableSave',
        );
        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    public function process(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $viewer = $this->getViewer($request);
        $existingDeliveryNoteID = $request->get("add2DeliveryNote");
        $sourceRecord = $request->get("sourceRecord");
        $sourceModule = $request->get("sourceModule");

        //handle related products
        $toDeliverQuantities = ITS4YouWarehouses_Products_Helper::getItemsQtyFromRequest($request);
        //itemIdx for final array relatedProducts
        $itemIdx = 1;
        //parent record model for retrieving basic module data (in case action != add2DN) 
        //as well as inventory product data (also in case when products are merged and action is add2DN)
        //like subproducts, comments        
        $parentRecordModel = Vtiger_Record_Model::getInstanceById($sourceRecord, $sourceModule);
        /* @var $parentRecordModel Inventory_Record_Model */
        $relatedProducts = array();

        if (!empty($existingDeliveryNoteID)) {
            $recordModel = Inventory_Record_Model::getInstanceById($existingDeliveryNoteID, $moduleName);
            $currencyInfo = $recordModel->getCurrencyInfo();
            $taxes = $recordModel->getProductTaxes();
            $shippingTaxes = $recordModel->getShippingTaxes();
            $relatedProducts = $recordModel->getProducts();
            $viewer->assign('RECORD_ID', $existingDeliveryNoteID);
            $viewer->assign('MODE', 'edit');
            $viewer->assign('STATUS', $recordModel->get("deliverynotestatus"));

            //related Products
            $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory($moduleName, $existingDeliveryNoteID);
            /* @var $actionBlock ITS4YouWarehouses_DN_ActionBlock */
            $relatedProducts = $actionBlock->enhanceRelProductsWithDistribution($relatedProducts);
            $itemIdx = count($relatedProducts) + 1;
        } else {
            $recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);

            $recordModel->set("parent_id", $parentRecordModel->get("account_id"));
            $recordModel->set("contact_id", $parentRecordModel->get("contact_id"));
            $recordModel->set("currency_id", $parentRecordModel->get("currency_id"));
            $recordModel->set("conversion_rate", $parentRecordModel->get("conversion_rate"));
            $recordModel->set("assigned_user_id", $parentRecordModel->get("assigned_user_id"));

            $recordModel->set("issue_date", DateTimeField::convertToDBFormat(getNewDisplayDate()));
            $recordModel->set("deliverynotetype", "Sale");
            //address
            $recordModel->set("ship_street", $parentRecordModel->get("ship_street"));
            $recordModel->set("ship_city", $parentRecordModel->get("ship_city"));
            $recordModel->set("ship_state", $parentRecordModel->get("ship_state"));
            $recordModel->set("ship_code", $parentRecordModel->get("ship_code"));
            $recordModel->set("ship_country", $parentRecordModel->get("ship_country"));
            $recordModel->set("ship_pobox", $parentRecordModel->get("ship_pobox"));

            switch ($sourceModule) {
                case "SalesOrder":
                    $recordModel->set("deliverynote_carrier", $parentRecordModel->get("carrier"));
                    $recordModel->set("referenceid", $parentRecordModel->getId());
                    break;

                case "Invoice":
                    $recordModel->set("invoice_id", $parentRecordModel->getId());
                    break;
            }

            $currencyInfo = $parentRecordModel->getCurrencyInfo();
            $taxes = $parentRecordModel->getProductTaxes();
            $shippingTaxes = $parentRecordModel->getShippingTaxes();
        }

        $warehouseRecordModels = array();
        $productRecordModels = array();
        if ($request->get("mergeProducts") == "false") {
            $distribution = $this->getDefaultQuantityDistributionLineItems($toDeliverQuantities);
            $isLineItemsDistribution = true;
        } else {
            $distribution = $this->getDefaultQuantityDistribution($toDeliverQuantities);
            $isLineItemsDistribution = false;
            $parentRelatedProducts = $parentRecordModel->getProducts();
        }
//        show($distribution);exit;
        //$itemIdx is used from the beginning of method because it can be increased in branch for add2DeliveryNote
        foreach ($distribution as $itemId => $warehouseQuantity) {
            if ($isLineItemsDistribution) {
                $lineItem = ITS4YouWarehouses_InventoryLineItem_Helper::getLineItemFromDB($itemId);
                /* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
                $productId = $lineItem->getProductId();
                //general product data
                $relatedProducts[$itemIdx]["hdnProductId" . $itemIdx] = $productId;
                $relatedProducts[$itemIdx]["productName" . $itemIdx] = $lineItem->getName();
                //subproducts                    
                $relatedProducts[$itemIdx]["subproduct_ids" . $itemIdx] = $lineItem->getSubProductIds(true);
                $relatedProducts[$itemIdx]["subprod_names" . $itemIdx] = $lineItem->getSubProductNames(true);
                $relatedProducts[$itemIdx]["comment" . $itemIdx] = $lineItem->getComment();
                //lineItemId for CrossInventoryRel
                $relatedProducts[$itemIdx]["lineItemId" . $itemIdx] = $itemId;
            } else {
                $productId = $itemId;
                if (!isset($productRecordModels[$productId])) {
                    $productRecordModels[$productId] = Vtiger_Record_Model::getInstanceById($productId);
                }
                //general product data
                $productRecordModel = $productRecordModels[$productId];
                /* @var $productRecordModel Products_Record_Model */
                $relatedProducts[$itemIdx]["hdnProductId" . $itemIdx] = $productId;
                $relatedProducts[$itemIdx]["productName" . $itemIdx] = $productRecordModel->getName();
                //subproducts
                $subProductsEditData = $this->getParentItemData($productId, $parentRelatedProducts);
                $relatedProducts[$itemIdx]["subproduct_ids" . $itemIdx] = $subProductsEditData["subproduct_ids"];
                $relatedProducts[$itemIdx]["subprod_names" . $itemIdx] = $subProductsEditData["subprod_names"];
                $relatedProducts[$itemIdx]["comment" . $itemIdx] = $subProductsEditData["comment"];
            }

            $totalDistributedQty = 0.0;
            foreach ($warehouseQuantity as $warehouseId => $quantity) {
                if ($warehouseId > 0) { // in case of Services or Products without stock movement => dummy warehouse is -1, resp. 0
                    if (!isset($warehouseRecordModels[$warehouseId])) {
                        $warehouseRecordModels[$warehouseId] = Vtiger_Record_Model::getInstanceById($warehouseId);
                    }
                    $warehouseRecordModel = $warehouseRecordModels[$warehouseId];

                    //common warehouse data                    
                    $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["hdnWarehouseId"] = $warehouseId;
                    $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["warehouseName"] = $warehouseRecordModel->getName();
                    $productQtyInStock = $warehouseRecordModel->getProductQtyInStock($productId);
                } else {
                    $productQtyInStock = 0;
                }
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["qty"] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($quantity);
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["qtyInStockRaw"] = $productQtyInStock;
                $relatedProducts[$itemIdx]["distribution" . $itemIdx][$warehouseId]["qtyInStock"] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($productQtyInStock);
                $totalDistributedQty += $quantity;
            }
            // in case of Services or Products without stock movement => dummy warehouse is -1, resp. 0
            if ($warehouseId >= 0) {
                $relatedProducts[$itemIdx]["entityType" . $itemIdx] = "Products";
            } else {
                $relatedProducts[$itemIdx]["entityType" . $itemIdx] = "Services";
            }

            $relatedProducts[$itemIdx]["totalDistributedQty" . $itemIdx] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($totalDistributedQty);
            $relatedProducts[$itemIdx]["totalDistributedQtyForEdit" . $itemIdx] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForEditView($totalDistributedQty);
            $itemIdx++;
        }

        $viewer->assign('MERGE_PRODUCTS', $request->get("mergeProducts"));

        //general Edit.php part
        $moduleModel = $recordModel->getModule();
        $fieldList = $moduleModel->getFields();
        $requestFieldList = array_intersect_key($request->getAll(), $fieldList);

        //get the inventory terms and conditions
        $inventoryRecordModel = Inventory_Record_Model::getCleanInstance($moduleName);
        $termsAndConditions = $inventoryRecordModel->getInventoryTermsandConditions();

        foreach ($requestFieldList as $fieldName => $fieldValue) {
            $fieldModel = $fieldList[$fieldName];
            if ($fieldModel->isEditable()) {
                $recordModel->set($fieldName, $fieldModel->getDBInsertValue($fieldValue));
            }
        }
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);

        $viewer->assign('VIEW_MODE', "fullForm");
        $isRelationOperation = $request->get('relationOperation');
        //if it is relation edit
        $viewer->assign('IS_RELATION_OPERATION', $isRelationOperation);
        if ($isRelationOperation) {
            $viewer->assign('SOURCE_MODULE', $sourceModule);
            $viewer->assign('SOURCE_RECORD', $sourceRecord);
        }
        $viewer->assign('IS_DUPLICATE', false);
        $currencies = Inventory_Module_Model::getAllCurrencies();
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);

        $viewer->assign('PICKIST_DEPENDENCY_DATASOURCE', Zend_Json::encode($picklistDependencyDatasource));
        $viewer->assign('RECORD', $recordModel);
        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('CURRENTDATE', date('Y-n-j'));
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());

        $viewer->assign('RELATED_PRODUCTS', $relatedProducts);
        $viewer->assign('SHIPPING_TAXES', $shippingTaxes);
        $viewer->assign('TAXES', $taxes);
        $viewer->assign('CURRENCINFO', $currencyInfo);
        $viewer->assign('CURRENCIES', $currencies);
        $viewer->assign('TERMSANDCONDITIONS', $termsAndConditions);

        $productModuleModel = Vtiger_Module_Model::getInstance('Products');
        $viewer->assign('PRODUCT_ACTIVE', $productModuleModel->isActive());
        $viewer->assign('SERVICE_ACTIVE', false);
        $viewer->view('EditView.tpl', $moduleName);
    }

    protected function getDefaultQuantityDistribution($toDeliverQuantities)
    {
        $db = PearDatabase::getInstance();
        $workToDeliverQuantities = $toDeliverQuantities;

        $sql = "SELECT  DISTINCT vtiger_inventoryproductrel.productid, 
                        CASE WHEN its4you_warehouses_productrel.warehouseid != '' THEN its4you_warehouses_productrel.warehouseid ELSE '0' END AS warehouseid,                         
                        CASE WHEN its4you_warehouses_productrel.warehouseid != '' THEN its4you_warehouses_productrel.quantity ELSE '0' END AS quantity,      
                        crm_prod.setype
                FROM vtiger_inventoryproductrel
                LEFT JOIN its4you_warehouses_productrel                 
                    ON its4you_warehouses_productrel.productid = vtiger_inventoryproductrel.productid
                LEFT JOIN vtiger_crmentity
                    ON its4you_warehouses_productrel.warehouseid = vtiger_crmentity.crmid     
                LEFT JOIN vtiger_crmentity AS crm_prod
                    ON vtiger_inventoryproductrel.productid = crm_prod.crmid
                LEFT JOIN vtiger_users 
                    ON vtiger_users.id = vtiger_crmentity.smownerid
                LEFT JOIN vtiger_groups 
                    ON vtiger_groups.groupid = vtiger_crmentity.smownerid
                WHERE (vtiger_crmentity.deleted = 0 OR vtiger_crmentity.deleted IS NULL)                
                    AND (vtiger_inventoryproductrel.productid IN (" . generateQuestionMarks($workToDeliverQuantities) . ") OR vtiger_inventoryproductrel.productid IS NULL)
                    " . getListViewSecurityParameter("ITS4YouWarehouses") . "
                ORDER BY vtiger_inventoryproductrel.productid,
                         its4you_warehouses_productrel.warehouseid";
        //put data into separate array in order to prioritize user's warehouses
        $result = $db->pquery($sql, array_keys($workToDeliverQuantities));
        $unsortedData = array();
        while ($row = $db->fetchByAssoc($result)) {
            $productId = $row["productid"];
            $warehouseId = $row["warehouseid"];
            $stockQty = ($row["quantity"] < 0 ? 0 : $row["quantity"]);
            $entityType = $row["setype"];
            if ($entityType == "Services" && $warehouseId == 0) {
                $warehouseId = -1;
            }

            $unsortedData[$productId][$warehouseId] = $stockQty;
        }

        $distribution = array();
        foreach ($unsortedData as $productId => $whData) {
            //sort data by prioritizing user's warehouses
            //callback function _user_warehouse_cmp is method of parent class
            uksort($whData, array($this, "_user_warehouse_cmp"));

            foreach ($whData as $warehouseId => $stockQty) {
                $deliverQty = $workToDeliverQuantities[$productId];

                if ($deliverQty <= 0) {
                    break;
                }

                if ($stockQty >= $deliverQty) {
                    $distributedQty = $deliverQty;
                    $workToDeliverQuantities[$productId] = 0;
                } else {
                    $distributedQty = $stockQty;
                    $workToDeliverQuantities[$productId] = $deliverQty - $stockQty;
                }

                if ($distributedQty > 0) {
                    $distribution[$productId][$warehouseId] = $distributedQty;
                } elseif ($warehouseId <= 0) { // in case of Services => use original qty
                    $distribution[$productId][$warehouseId] = $workToDeliverQuantities[$productId];
                }
            }
        }

        return $this->completeQuantityDistribution($workToDeliverQuantities, $distribution);
    }

}
