<?php

/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_Preferences_Model extends Vtiger_Base_Model
{

    const PREFNAME_SERVICES_ENABLED = "servicesEnabled";
    /**
     * Default values of preferences. List all preferences which are supported
     * and assign them default value.
     * @var array
     */
    private static $defaultSet = array(
        self::PREFNAME_SERVICES_ENABLED => "0"
    );
    /**
     * Formatters methods
     * @var array formatting methods
     */
    private static $defaultFormatters = array(
        self::PREFNAME_SERVICES_ENABLED => "formatNumericBoolean"
    );
    /**
     * Model pool
     * @var array pool of loaded preference models
     */
    private static $preferencesPool = array();
    private $name;
    private $value;
    private $modifiedBy;
    private $modifiedTime;

    public static function loadAll()
    {
        $db = PearDatabase::getInstance();
        $sql = "SELECT * FROM its4you_preferences";
        $result = $db->pquery($sql, array());
        $preferenceInstances = array();
        while ($row = $db->fetchByAssoc($result)) {
            $instance = new ITS4YouWHDeliveryNotes_Preferences_Model();
            $instance->name = $row["name"];
            $instance->value = $row["value"];
            $instance->modifiedBy = $row["modifiedby"];
            $instance->modifiedTime = $row["modifiedtime"];

            $preferenceInstances[$instance->name] = $instance;
        }

        foreach (self::$defaultSet as $name => $value) {
            if (!isset($preferenceInstances[$name])) {
                $instance = new ITS4YouWHDeliveryNotes_Preferences_Model();
                $instance->name = $name;
                $instance->value = $value;

                $preferenceInstances[$instance->name] = $instance;
            }
        }

        self::$preferencesPool = $preferenceInstances;

        return $preferenceInstances;
    }

    public static function getInstance($name)
    {
        if (!isset(self::$preferencesPool[$name])) {
            self::$preferencesPool[$name] = self::load($name);
        }

        return self::$preferencesPool[$name];
    }

    /**
     * @param string $name Name of the preference
     * @return ITS4YouWHDeliveryNotes_Preferences_Model instance of Preferences loaded from DB
     */
    private static function load($name)
    {
        $db = PearDatabase::getInstance();
        $sql = "SELECT * FROM its4you_preferences WHERE name = ?";
        $result = $db->pquery($sql, array($name));
        if ($row = $db->fetchByAssoc($result)) {
            $instance = new ITS4YouWHDeliveryNotes_Preferences_Model();
            $instance->name = $row["name"];
            $instance->value = $row["value"];
            $instance->modifiedBy = $row["modifiedby"];
            $instance->modifiedTime = $row["modifiedtime"];

            return $instance;
        }
        $defaultInstance = self::loadDefault($name);
        if ($defaultInstance === null) {
            throw new Exception("ITS4YouWHDeliveryNotes :: Unsupported Preference name '" . $name . "'");
        }
        return $defaultInstance;
    }

    /**
     * @param $_name
     *
     * @return ITS4YouWHDeliveryNotes_Preferences_Model|null
     */
    private static function loadDefault($_name)
    {
        foreach (self::$defaultSet as $name => $value) {
            if ($name === $_name) {
                $instance = new ITS4YouWHDeliveryNotes_Preferences_Model();
                $instance->name = $name;
                $instance->value = $value;

                return $instance;
            }
        }
        return null;
    }

    /**
     * Mapping between formatter and uitype
     * @return int
     */
    public function getUIType()
    {
        $formatter = "";
        if (isset(self::$defaultFormatters[$this->name])) {
            $formatter = self::$defaultFormatters[$this->name];
        }

        switch ($formatter) {
            case "formatNumericBoolean":
                return 56;

            default:
                return 1;
        }
    }

    public function getValue()
    {
        return $this->value;
    }

    public function setValue($prefValue)
    {
        $this->value = $prefValue;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($prefName)
    {
        $this->name = $prefName;
    }

    public function getModifiedBy()
    {
        return $this->modifiedBy;
    }

    public function getModifiedTime()
    {
        return $this->modifiedTime;
    }

    public function getLabel()
    {
        return vtranslate($this->name, "ITS4YouWHDeliveryNotes");
    }

    public function getDetailViewValue()
    {
        return $this->getFormattedValue(true);
    }

    private function getFormattedValue($forDetailView)
    {
        foreach (self::$defaultFormatters as $name => $formatter) {
            if ($this->name === $name) {
                return call_user_func(array($this, $formatter), $forDetailView);
            }
        }
        return $this->value;
    }

    public function getEditViewValue()
    {
        return $this->getFormattedValue(false);
    }

    public function setEditViewValue($editViewValue)
    {
        foreach (self::$defaultFormatters as $name => $formatter) {
            if ($this->name === $name) {
                $this->value = call_user_func(array($this, "de" . $formatter), $editViewValue);
                return;
            }
        }
        $this->value = $editViewValue;
    }

    public function save()
    {
        $db = PearDatabase::getInstance();
        $date_var = date("Y-m-d H:i:s");
        $currentUserModel = Users_Record_Model::getCurrentUserModel();
        /* @var $currentUserModel Users_Record_Model */

        $sql = "INSERT INTO its4you_preferences (name, value, modifiedby, modifiedtime) 
                    VALUES(?,?,?,?)
                    ON DUPLICATE KEY UPDATE value = ?, modifiedby = ?, modifiedtime = ?";

        $db->pquery($sql, array(
            $this->name,
            $this->value,
            $currentUserModel->getId(),
            $db->formatDate($date_var, true),
            $this->value,
            $currentUserModel->getId(),
            $db->formatDate($date_var, true)
        ));
    }

    /**
     * Formatter methods which are invoked dynamically
     *
     * @param $forDetailView
     *
     * @return bool|mixed
     */
    public function formatNumericBoolean($forDetailView)
    {
        if ($forDetailView) {
            return ($this->value == "0" ? vtranslate("LBL_NO") : vtranslate("LBL_YES"));
        } else {
            return ($this->value == "0" ? false : true);
        }
    }

    public function deformatNumericBoolean($editViewValue)
    {
        return ($editViewValue == "on" ? "1" : "0");
    }

}
