<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

/**
 * update given qtyInStock value with qty value by stage of update ( + or - )
 *
 * @param $qtyInStock
 * @param $qty
 * @param $stage
 *
 * @return mixed
 */
function getUpdatedQtyInStockByStage($qtyInStock, $qty, $stage)
{
    switch ($stage) {
        case 'Canceled':
            $qtyInStock += $qty;
            break;
        case 'Delivered':
        case 'Invoiced':
            $qtyInStock -= $qty;
            break;
    }

    return $qtyInStock;
}

/**
 * @param $entity
 *
 * @throws Exception
 */
function updateInventoryProductRelDeliveryNotes($entity)
{
    global $log, $adb, $dnBeforeStatus;
    //$request = new Vtiger_Request($_REQUEST, $_REQUEST);

    $entityId = vtws_getIdComponents($entity->getId());
    $entityId = $entityId[1];
    $status = $entity->get(ITS4YouWHDeliveryNotes::$statusFieldName);

    if (in_array($status, ['Canceled', 'Delivered', 'Invoiced'])) {
        $recordModel = Inventory_Record_Model::getInstanceById($entityId);
        if ($recordModel) {
            $productDetails = $recordModel->getProducts();
            foreach ($productDetails as $ri => $lineItem) {
                if ('Products' === $lineItem['entityType' . $ri]) {
                    $productId = $lineItem['hdnProductId' . $ri];
                    $qty = $lineItem['qty' . $ri];

                    $productModuleName = 'Products';
                    $productModel = Vtiger_Record_Model::getInstanceById($productId, $productModuleName);
                    $qtyInStock = (float)($productModel->get('qtyinstock') ? $productModel->get('qtyinstock') : 1);

                    if ($productModel->isBundle()) {
                        $subProducts = $productModel->getSubProducts($active = true);
                        foreach ($subProducts as $subItem) {
                            $subProductId = $subItem->getId();
                            if ('' !== $subItem->get('qtyinstock') && $subItem->get('qtyinstock') && is_numeric($subItem->get('qtyinstock'))) {
                                $subQtyInStock = (float)$subItem->get('qtyinstock');
                            } else {
                                $subQtyInStock = (float)0;
                            }
                            if ('' !== $subItem->get('quantityInBundle') && $subItem->get('quantityInBundle') && is_numeric($subItem->get('quantityInBundle'))) {
                                $quantityInBundle = (float)$subItem->get('quantityInBundle');
                            } else {
                                $quantityInBundle = (float)1;
                            }

                            $movedQuantity = $qty * $quantityInBundle;
                            $subQtyInStock = getUpdatedQtyInStockByStage($subQtyInStock, $movedQuantity, $status);
                            /** run update Product Qty */
                            updateProductQty($subProductId, $subQtyInStock);
                        }
                    } else {
                        $qtyInStock = getUpdatedQtyInStockByStage($qtyInStock, $qty, $status);
                        /** run update Product Qty */
                        updateProductQty($productId, $qtyInStock);
                    }
                }
            }
        }
    }
}

/**
 * @param $entity
 *
 * @throws Exception
 */
function handleInventoryProductRelDeliveryNotes($entity)
{
    require_once("include/utils/InventoryUtils.php");

    $moduleName = $entity->getModuleName();
    if ('ITS4YouWHDeliveryNotes' === $moduleName) {
        global $dnBeforeStatus;
        $adb = PearDatabase::getInstance();

        $entityId = vtws_getIdComponents($entity->getId());
        $entityId = $entityId[1];

        $status = $entity->get(ITS4YouWHDeliveryNotes::$statusFieldName);

        $lastStatusResult = $adb->pquery('SELECT deliverylaststatus FROM its4you_deliverynotes WHERE deliverynoteid=?', [$entityId]);
        $lastStatusRow = $adb->fetch_row($lastStatusResult);
        $dnBeforeStatus = $lastStatusRow['deliverylaststatus'];

        $statusChanged = ($dnBeforeStatus !== $status);

        if ($statusChanged &&
            'Delivered' !== $dnBeforeStatus &&
            in_array($status, ['Delivered', 'Invoiced'])) {
            updateInventoryProductRelDeliveryNotes($entity);
        } elseif ($statusChanged &&
            in_array($dnBeforeStatus, ['Delivered', 'Invoiced']) &&
            'Canceled' === $status) {
            updateInventoryProductRelDeliveryNotes($entity);
        }
    }
}

?>
