<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWHDeliveryNotes_ProductWHRelatedList_Action extends Vtiger_Action_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('getRelatedListPageCount');
    }

    public function checkPermission(Vtiger_Request $request)
    {
    }

    public function preProcess(Vtiger_Request $request)
    {
        return true;
    }

    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }

    /**
     * Function to get the page count for reltedlist
     * @return total number of pages
     */
    public function getRelatedListPageCount(Vtiger_Request $request)
    {
        $parentId = $request->get('record');
        $pagingModel = new Vtiger_Paging_Model();

        $className = "ITS4YouWHDeliveryNotes_" . $request->get("forView") . "_View";
        $viewModel = new $className();
        $listViewModel = $viewModel->getListViewModel($request);

        $searchParmams = $request->get('search_params');
        if (empty($searchParmams)) {
            $searchParmams = array();
        }
        $transformedSearchParams = ITS4YouWarehouses_Util_Helper::transferListSearchParamsToFilterCondition($searchParmams, $listViewModel->getHeaders());
        $listViewModel->set('search_params', $transformedSearchParams);

        $totalCount = $listViewModel->getListViewCount();
        $pageLimit = $pagingModel->getPageLimit();
        $pageCount = ceil((int)$totalCount / (int)$pageLimit);

        if ($pageCount == 0) {
            $pageCount = 1;
        }
        $result = array();
        $result['numberOfRecords'] = $totalCount;
        $result['page'] = $pageCount;

        $response = new Vtiger_Response();
        $response->setResult($result);
        $response->emit();
    }

    public function validateRequest(Vtiger_Request $request)
    {
        $request->validateWriteAccess();
    }

}
