<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouReceiptcards_Record_Model extends ITS4YouWarehouses_InventoryRecord_Model
{
    public function getTypeFromModule($module)
    {
        switch ($module) {
            case 'Vendors':
                return 'From supplier';

            case 'Accounts':
                return 'From customer';

            case 'ITS4YouWarehouseTransfers':
                return 'Warehouse transfer';

            case 'ITS4YouIssuecards':
                return 'Products return';
        }

        return '';
    }

    public function getStatus()
    {
        if (!$this->isEmpty('adoption_date') && DateTimeField::convertToDBFormat($this->get('adoption_date')) <= date('Y-m-d')) {
            return 'Delivered';
        }

        return 'Created';
    }

    public function getTypeFromVendor()
    {
        if (!$this->isEmpty('vendor_id')) {
            $entityType = getSalesEntityType($this->get('vendor_id'));

            return $this->getTypeFromModule($entityType);
        }

        return '';
    }
}
