<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouReceiptcards_Save_Action extends Inventory_Save_Action
{
    /**
     * @param Vtiger_Request $request
     * @return ITS4YouReceiptcards_Record_Model
     */
    protected function getRecordModelFromRequest(Vtiger_Request $request)
    {
        /** @var ITS4YouReceiptcards_Record_Model $recordModel */
        $recordModel = parent::getRecordModelFromRequest($request);

        if ($recordModel->isEmpty('mode') && $recordModel->isEmpty('receiptcardstatus')) {
            $recordModel->set('receiptcardstatus', $recordModel->getStatus());
        }

        if ('ReturnProducts' === $request->get('view')) {
            $rcType = 'Products return';
        } else {
            $rcType = $recordModel->getTypeFromVendor();
        }

        $recordModel->set('receiptcardtype', $rcType);

        return $recordModel;
    }
}
