<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouReceiptcards extends CRMEntity
{

    public $log;
    public $db;
    public $table_name = 'its4you_receiptcards';
    public $table_index = 'receiptcardid';
//    public $column_fields = Array();

    /** Indicator if this is a custom module or standard module */
//    public $IsCustomModule = true;

    /**
     * Mandatory table for supporting custom fields.
     */
    public $customFieldTable = Array('its4you_receiptcardscf', 'receiptcardid');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    public $tab_name = Array('vtiger_crmentity', 'its4you_receiptcards', 'its4you_receiptcardscf', 'vtiger_inventoryproductrel');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    public $tab_name_index = Array(
        'vtiger_crmentity' => 'crmid',
        'its4you_receiptcards' => 'receiptcardid',
        'its4you_receiptcardscf' => 'receiptcardid',
        'vtiger_inventoryproductrel' => 'id'
    );

    /**
     * Mandatory for Listing (Related listview)
     */
    public $list_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'vtiger_'
        'ITS4YouReceiptcards No' => Array('receiptcards' => 'receiptcards_no'),
        'Status' => Array('receiptcards' => 'receiptcardstatus'),
        'Adoption Date' => Array('receiptcards' => 'adoption_date'),
        'Related To' => Array('receiptcards' => 'vendorid'),
        'Contact Name' => Array('receiptcards' => 'contactid'),
//        'Description' => Array('crmentity' => 'description'),        
        'Assigned To' => Array('crmentity' => 'smownerid')
    );
    public $list_fields_name = Array(
        /* Format: Field Label => fieldname */
        'ITS4YouReceiptcards No' => 'receiptcards_no',
        'Related To' => 'vendor_id',
        'Contact Name' => 'contact_id',
        'Description' => 'description',
        'Adoption Date' => 'adoption_date',
        'Status' => 'receiptcardstatus',
        'Assigned To' => 'assigned_user_id'
    );
    // Make the field link to detail view from list view (Fieldname)
    public $list_link_field = 'receiptcards_no';
    // For Popup listview and UI type support
    public $search_fields = Array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'vtiger_'
        'ITS4YouReceiptcards No' => Array('receiptcards', 'receiptcards_no')
    );
    public $search_fields_name = Array(
        /* Format: Field Label => fieldname */
        'ITS4YouReceiptcards No' => 'receiptcards_no'
    );
    // For Popup window record selection
//    public $popup_fields = Array('receiptcards_no', 'startdate');
    public $popup_fields = Array('receiptcards_no');
    // Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
//    public $sortby_fields = Array();
    // For Alphabetical search
    public $def_basicsearch_col = 'receiptcards_no';
    // Column value to use on detail view record text display
    public $def_detailview_recname = 'receiptcards_no';
    // Required Information for enabling Import feature
//    public $required_fields = Array('receiptcards_no' => 1);
//    public $special_functions = Array('set_import_assigned_user');
    // Used when enabling/disabling the mandatory fields for the module.
    // Refers to vtiger_field.fieldname values.
    public $mandatory_fields = Array('createdtime', 'modifiedtime', 'receiptcards_no', 'warehouseid');
    // Callback function list during Importing
    public $default_order_by = 'receiptcards_no';
    public $default_sort_order = 'ASC';
    // For workflows update field tasks is deleted all the lineitems.
    public $isLineItemUpdate = true;
//    public $update_product_array = Array();
    // This is used to retrieve related vtiger_fields from form posts.
    public $additional_column_fields = Array('assigned_user_name', 'smownerid', 'vendorid', 'currency_id');
    public $column_fields;
    public $moduleName = 'ITS4YouReceiptcards';
    public $parentName = 'Inventory';

    public function __construct()
    {
        global $log;

        $this->log = $log;
        $this->column_fields = getColumnFields($this->moduleName);
        $this->db = PearDatabase::getInstance();
    }

    public function insertIntoEntityTable($table_name, $module, $fileid = '')
    {
        //Ignore relation table insertions while saving of the record
        if ($table_name != 'vtiger_inventoryproductrel') {
            parent::insertIntoEntityTable($table_name, $module, $fileid);
        }
    }

    public function vtlib_handler($moduleName, $event_type)
    {
        require_once 'vtlib/Vtiger/Module.php';
        require_once 'modules/ModTracker/ModTracker.php';
        require_once 'modules/ModComments/ModComments.php';
        include_once 'vtlib/Vtiger/Event.php';

        switch ($event_type) {
            case 'module.postinstall':
                $this->addFields();
                $this->addCustomLinks();
                break;
            case 'module.postupdate':
            case 'module.enabled':
                $this->addCustomLinks();
                break;
            case 'module.preuninstall':
            case 'module.preupdate':
            case 'module.disabled':
                $this->deleteCustomLinks();
                break;
        }
    }

    public function addFields()
    {
        $moduleInstance = Vtiger_Module::getInstance('Products');
        $blockInstance = Vtiger_Block::getInstance('LBL_STOCK_INFORMATION', $moduleInstance);
        $fieldInstance = Vtiger_Field::getInstance('optimallevel', $moduleInstance);

        if ($blockInstance && !$fieldInstance) {
            $fieldInstance = new Vtiger_Field();
            $fieldInstance->name = 'optimallevel';
            $fieldInstance->label = 'OptimalLevel';
            $fieldInstance->table = $moduleInstance->basetable;
            $fieldInstance->column = 'optimallevel';
            $fieldInstance->columntype = 'INT(11)';
            $fieldInstance->uitype = 1;
            $fieldInstance->typeofdata = 'I~O';
            $blockInstance->addField($fieldInstance);

            Vtiger_Utils::AddColumn($fieldInstance->table, $fieldInstance->column, $fieldInstance->columntype);
        }
    }

    /**
     * @var array
     * [module, related module, relate label, related actions, related function]
     * $moduleInstance->setRelatedList($relatedListModule, $relatedLabel, $relatedActions, $relatedFunction);
     */
    public $registerRelatedLists = [
        ['PurchaseOrder', 'ITS4YouReceiptcards'],
        ['PurchaseOrder', 'Invoice',],
        ['ITS4YouReceiptcards', 'PurchaseOrder'],
        ['ITS4YouReceiptcards', 'ITS4YouWarehouseTransfers'],
        ['ITS4YouReceiptcards', 'ITS4YouIssuecards'],
        ['ITS4YouWHDeliveryNotes', 'ITS4YouReceiptcards'],
        ['SalesOrder', 'ITS4YouReceiptcards'],
        ['SalesOrder', 'PurchaseOrder'],
        ['PurchaseOrder', 'SalesOrder'],
        ['Invoice', 'ITS4YouReceiptcards'],
        ['Invoice', 'PurchaseOrder'],
        ['Products', 'ITS4YouReceiptcards'],
        ['ITS4YouWarehouseTransfers', 'ITS4YouReceiptcards'],
        ['ITS4YouIssuecards', 'ITS4YouReceiptcards'],
        ['Vendors', 'ITS4YouReceiptcards'],
        ['Accounts', 'ITS4YouReceiptcards'],
        ['ITS4YouWarehouses', 'ITS4YouReceiptcards', 'ITS4YouReceiptcards', '', 'get_receiptcards'],
        ['ITS4YouReceiptcards', 'Documents', 'Documents', 'ADD,SELECT', 'get_attachments'],
    ];

    public function updateNumbering()
    {
        $this->setModuleSeqNumber('configure', $this->moduleName, 'RC', 1);
        $this->updateMissingSeqNumber($this->moduleName);
    }

    public function addCustomLinks()
    {
        $this->updateRelatedList();
        $this->updateFields();
        $this->updateNumbering();
        $this->updateReferenceList();

        Settings_MenuEditor_Module_Model::addModuleToApp($this->moduleName, $this->parentName);
        ModTracker::enableTrackingForModule(getTabid($this->moduleName));
        ModComments::addWidgetTo([$this->moduleName]);
    }

    public function updateReferenceList()
    {
        $module = Vtiger_Module_Model::getInstance($this->moduleName);
        $field = $module ? $module->getField('referenceid') : false;

        if ($field) {
            $field->setRelatedModules([
                'PurchaseOrder',
                'Invoice',
                'SalesOrder',
                'ITS4YouDeliveryNotes',
                'ITS4YouWHDeliveryNotes',
            ]);
        }
    }


    public function updateFields()
    {
        $this->db->pquery('UPDATE vtiger_field SET typeofdata=? WHERE columnname=? AND tablename=?', ['D~O', 'adoption_date', 'its4you_receiptcards']);

        $this->updateItemDetailFields();
    }

    public function updateItemDetailFields()
    {
        $fieldNames = array('txtAdjustment', 'hdnSubTotal', 'hdnGrandTotal', 'hdnDiscountAmount', 'hdnS_H_Amount', 'pre_tax_total');
        $this->db->pquery('UPDATE vtiger_field SET uitype=? WHERE tabid=? AND fieldname IN(' . generateQuestionMarks($fieldNames) . ')',
            array(72, getTabid($this->moduleName), $fieldNames)
        );
    }

    public function deleteCustomLinks()
    {
        $this->updateRelatedList(false);

        ModTracker::disableTrackingForModule(getTabid($this->moduleName));
        ModComments::removeWidgetFrom([$this->moduleName]);
    }

    /**
     * @param bool $register
     */
    public function updateRelatedList($register = true)
    {
        foreach ($this->registerRelatedLists as $relatedList) {
            $module = Vtiger_Module::getInstance($relatedList[0]);
            $relatedModule = Vtiger_Module::getInstance($relatedList[1]);

            if ($module && $relatedModule) {
                $relatedLabel = isset($relatedList[2]) ? $relatedList[2] : $relatedModule->name;
                $relatedActions = isset($relatedList[3]) ? $relatedList[3] : '';
                $relatedFunction = isset($relatedList[4]) ? $relatedList[4] : 'get_related_list';
                $field = isset($relatedList[5]) ? Vtiger_Field_Model::getInstance($relatedList[5], $relatedModule) : '';
                $fieldId = $field ? $field->getId() : '';

                $module->unsetRelatedList($relatedModule, $relatedLabel);
                $module->unsetRelatedList($relatedModule, $relatedLabel, $relatedFunction);

                if ($register) {
                    $module->setRelatedList($relatedModule, $relatedLabel, $relatedActions, $relatedFunction, $fieldId);
                }
            }
        }
    }

    /**
     * @throws AppException
     * @throws Exception
     */
    public function save_module($module)
    {
        //in ajax save we should not call this function, because this will delete all the existing product values
        if (isset($_REQUEST['totalProductCount'])) {
            if ($_REQUEST['action'] != 'ITS4YouReceiptcardsAjax' && $_REQUEST['ajxaction'] != 'DETAILVIEW' && $_REQUEST['action'] != 'MassEditSave' && $_REQUEST['module'] != 'ITS4YouIncomingProducts' && $this->isLineItemUpdate != false) {
                //Based on the total Number of rows we will save the product relationship with this entity
                ITS4YouWarehouses_InventoryUtils_Helper::saveParentInventoryProducts($this);
            }
        }

        //update status manually because of displaytype / Update the currency id and the conversion rate for the invoice and also receiptcardtype
        $this->updateItemDetails();

        // create relationship between RC and related modules PO, SO, DN, INV
        $this->createRelationFromField('referenceid');

        // create relationship between RC and related modules Vendors, Accounts, WT, IC
        $this->createRelationFromField('vendor_id');

        $this->updateIssueCardsStatus();
    }

    /**
     * @throws Exception
     */
    public function updateIssueCardsStatus()
    {
        if (isset($this->id, $this->column_fields)) {
            ITS4YouWarehouses_SeqStatusActionHandler_Helper::updateIssueCardsStatus($this->id, $this->column_fields['vendor_id']);
        }
    }

    public function updateItemDetails()
    {
        $data = $this->column_fields;
        $params = array(
            'currency_id' => $data['currency_id'],
            'conversion_rate' => $data['conversion_rate'],
            'receiptcardtype' => $data['receiptcardtype'],
            'region_id' => $data['region_id'],
        );

        if (!empty($data['receiptcardstatus'])) {
            $params['receiptcardstatus'] = $data['receiptcardstatus'];
        }

        $query = sprintf('UPDATE its4you_receiptcards SET %s=? where receiptcardid=?', implode('=?,', array_keys($params)));
        $this->db->pquery($query, [$params, $this->id]);
    }

    /**
     * @param string $name
     * @throws AppException
     */
    public function createRelationFromField($name)
    {
        $module = Vtiger_Module_Model::getInstance($this->moduleName);
        $recordId = intval($this->column_fields[$name]);

        if (!empty($recordId)) {
            $parentModuleName = getSalesEntityType($recordId);
            $parentModule = Vtiger_Module_Model::getInstance($parentModuleName);

            if ($parentModule) {
                $relationModel = Vtiger_Relation_Model::getInstance($parentModule, $module);

                if ($relationModel) {
                    $relationModel->addRelation($recordId, $this->id);
                } else {
                    throw new AppException('Receipt Cards relation does not exists for parent: ' . $parentModuleName);
                }
            }
        }
    }

    /**
     * @param string $module
     * @param int $id
     * @throws Exception
     */
    public function restore($module, $id)
    {
        global $current_user;

        $this->db->println("TRANS restore starts $module");
        $this->db->startTransaction();

        $this->db->pquery('UPDATE vtiger_crmentity SET deleted=0 WHERE crmid = ?', array($id));
        //Restore related entities/records
        $this->restoreRelatedRecords($module, $id);

        $product_info = $this->db->pquery("SELECT productid, quantity, sequence_no, incrementondel from vtiger_inventoryproductrel WHERE id=?", array($id));
        $numrows = $this->db->num_rows($product_info);
        for ($index = 0; $index < $numrows; $index++) {
            $productid = $this->db->query_result($product_info, $index, 'productid');
            $qty = $this->db->query_result($product_info, $index, 'quantity');
            addToProductStock($productid, $qty);
        }

        $this->db->completeTransaction();
        $this->db->println("TRANS restore ends");

        ITS4YouWarehouses_RCUtil_ActionBlock::updateRelatedPurchaseOrderStatus($id);
    }

    /** Overriden function to delete an entity with given Id */
    public function trash($module, $id)
    {
        parent::trash($module, $id);
        ITS4YouWarehouses_RCUtil_ActionBlock::updateRelatedPurchaseOrderStatus($id);
    }

    /**
     * @param string $module
     * @param object $queryPlanner
     * @return string
     * @throws Exception
     */
    public function generateReportsQuery($module, $queryPlanner)
    {
        $query = parent::generateReportsQuery($module, $queryPlanner);

        //Vtiger loading field name instead of column
        $query = str_replace('its4you_receiptcards.vendor_id', 'its4you_receiptcards.vendorid', $query);

        // Define the dependency matrix ahead
        $matrix = $queryPlanner->newDependencyMatrix();
        $matrix->setDependency('vtiger_crmentity' . $this->moduleName, array('vtiger_users' . $this->moduleName, 'vtiger_groups' . $this->moduleName, 'vtiger_lastModifiedBy' . $this->moduleName));
        $matrix->setDependency('vtiger_inventoryproductrel' . $this->moduleName, array('vtiger_products' . $this->moduleName, 'vtiger_service' . $this->moduleName));


        $requiredTables = [
            'vtiger_inventoryproductrel' => 'id',
        ];

        $this->generateCustomReportsQuery($this->table_index, $this->table_name, $requiredTables, $queryPlanner, $query, 'tmp');

        $requiredTables = [
            'vtiger_currency_info' => 'id',
        ];

        $this->generateCustomReportsQuery('currency_id', $this->table_name, $requiredTables, $queryPlanner, $query, '');

        $requiredTables = [
            'vtiger_contactdetails' => 'contactid',
        ];

        $this->generateCustomReportsQuery('contactid', $this->table_name, $requiredTables, $queryPlanner, $query);

        $tableName = 'vtiger_inventoryproductreltmp' . $this->moduleName;
        $requiredTables = [
            'vtiger_products' => 'productid',
            'vtiger_service' => 'serviceid',
        ];

        $this->generateCustomReportsQuery('productid', $tableName, $requiredTables, $queryPlanner, $query, '');

        return $query;
    }

    /**
     * @param string $fieldName
     * @param string $tableName
     * @param array $requiredTables
     * @param object $queryPlanner
     * @param string $query
     * @param string $rel
     * @throws Exception
     */
    public function generateCustomReportsQuery($fieldName, $tableName, $requiredTables, &$queryPlanner, &$query, $rel = 'Rel')
    {
        $thisModule = $this->moduleName;
        $relFieldId = '';

        if ('Rel' === $rel) {
            $result = $this->db->pquery('SELECT fieldid FROM vtiger_field WHERE columnname = ? AND tablename = ?',
                array($fieldName, $tableName));
            $relFieldId = $this->db->query_result($result, 0, 'fieldid');
        }

        foreach ($requiredTables as $requiredTable => $requiredField) {
            $customRequiredTableName = $requiredTable . $rel . $thisModule . $relFieldId;

            if ($queryPlanner->requireTable($customRequiredTableName)) {
                $query .= sprintf(
                    ' LEFT JOIN %s AS %s ON %s.%s = %s.%s ',
                    $requiredTable,
                    $customRequiredTableName,
                    $customRequiredTableName,
                    $requiredField,
                    $tableName,
                    $fieldName
                );
            }
        }
    }
}
