<?php
/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Class ITS4YouOutgoingProducts_ListAjax_View
 */
class ITS4YouOutgoingProducts_ListAjax_View extends ITS4YouOutgoingProducts_List_View
{

    /**
     * ITS4YouOutgoingProducts_ListAjax_View constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('getListViewCount');
        $this->exposeMethod('getRecordsCount');
        $this->exposeMethod('getPageCount');
    }

    /**
     * @param Vtiger_Request $request
     * @param bool $display
     * @return bool|void
     */
    public function preProcess(Vtiger_Request $request, $display = true)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     */
    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }

}
