<?php

/**
 * Class ITS4YouOutgoingProducts_List_View
 */
class ITS4YouOutgoingProducts_List_View extends Vtiger_Index_View
{
    /**
     * @var bool
     */
    protected $listViewEntries = false;
    /**
     * @var bool
     */
    protected $listViewCount = false;
    /**
     * @var bool
     */
    protected $listViewLinks = false;
    /**
     * @var bool
     */
    protected $listViewHeaders = false;

    /**
     * @param Vtiger_Request $request
     * @param bool $display
     * @return bool|void
     * @throws Exception
     */
    public function preProcess(Vtiger_Request $request, $display = true)
    {
        vtws_addDefaultModuleTypeEntity($request->getModule());

        parent::preProcess($request, false);
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $linkParams = array('MODULE' => $moduleName, 'ACTION' => $request->get('view'));
        $quickLinkModels = $moduleModel->getSideBarLinks($linkParams);
        $viewer->assign('QUICK_LINKS', $quickLinkModels);
        $viewer->assign('LEFTPANELHIDE', 1);
        $this->initializeListViewContents($request, $viewer);

        if ($display) {
            $this->preProcessDisplay($request);
        }
    }

    /**
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     * @throws Exception
     */
    public function initializeListViewContents(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        $moduleName = $request->getModule();
        $pageNumber = $request->get('page');
        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');

        if ('ASC' === $sortOrder) {
            $nextSortOrder = 'DESC';
            $sortImage = 'icon-chevron-down';
            $faSortImage = 'fa-sort-desc';
        } else {
            $nextSortOrder = 'ASC';
            $sortImage = 'icon-chevron-up';
            $faSortImage = 'fa-sort-asc';
        }

        if (empty($pageNumber)) {
            $pageNumber = '1';
        }

        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $listViewModel = new ITS4YouOutgoingProducts_ListView_Model();
        $linkParams = array('MODULE' => $moduleName, 'ACTION' => $request->get('view'));
        $linkModels = $moduleModel->getListViewMassActions($linkParams);
        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set('page', $pageNumber);

        if (!empty($orderBy)) {
            $listViewModel->set('orderby', $orderBy);
            $listViewModel->set('sortorder', $sortOrder);
        }

        $searchKey = $request->get('search_key');
        $searchValue = $request->get('search_value');
        $operator = $request->get('operator');

        if (!empty($operator)) {
            $listViewModel->set('operator', $operator);
            $viewer->assign('OPERATOR', $operator);
            $viewer->assign('ALPHABET_VALUE', $searchValue);
        }

        if (!empty($searchKey) && !empty($searchValue)) {
            $listViewModel->set('search_key', $searchKey);
            $listViewModel->set('search_value', $searchValue);
        }

        $searchParmams = $request->get('search_params');

        if (empty($searchParmams)) {
            $searchParmams = array();
        }

        $transformedSearchParams = Vtiger_Util_Helper::transferListSearchParamsToFilterCondition($searchParmams, $moduleModel);
        $listViewModel->set('search_params', $transformedSearchParams);

        foreach ($searchParmams as $fieldListGroup) {
            foreach ($fieldListGroup as $fieldSearchInfo) {
                $fieldSearchInfo['searchValue'] = $fieldSearchInfo[2];
                $fieldSearchInfo['fieldName'] = $fieldName = $fieldSearchInfo[0];
                $searchParmams[$fieldName] = $fieldSearchInfo;
            }
        }

        if (!$this->listViewHeaders) {
            $this->listViewHeaders = $listViewModel->getListViewHeaders();
        }

        if (!$this->listViewEntries) {
            $this->listViewEntries = $listViewModel->getListViewEntries($pagingModel);
        }

        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('QUALIFIED_MODULE', $moduleName);
        $viewer->assign('LISTVIEW_LINKS', $moduleModel->getListViewLinks());
        $viewer->assign('LISTVIEW_MASSACTIONS', $linkModels);
        $viewer->assign('PAGING_MODEL', $pagingModel);
        $viewer->assign('PAGE_NUMBER', $pageNumber);
        $viewer->assign('ORDER_BY', $orderBy);
        $viewer->assign('SORT_ORDER', $sortOrder);
        $viewer->assign('FASORT_IMAGE', $faSortImage);
        $viewer->assign('NEXT_SORT_ORDER', $nextSortOrder);
        $viewer->assign('SORT_IMAGE', $sortImage);
        $viewer->assign('COLUMN_NAME', $orderBy);
        $viewer->assign('LISTVIEW_ENTRIES_COUNT', ITS4YouOutgoingProducts_Utils_Helper::count($this->listViewEntries));
        $viewer->assign('LISTVIEW_HEADERS', $this->listViewHeaders);
        $viewer->assign('LISTVIEW_ENTRIES', $this->listViewEntries);

        if (PerformancePrefs::getBoolean('LISTVIEW_COMPUTE_PAGE_COUNT', false)) {
            if (!$this->listViewCount) {
                $this->listViewCount = $listViewModel->getListViewCount();
            }

            $totalCount = $this->listViewCount;
            $pageLimit = $pagingModel->getPageLimit();
            $pageCount = ceil((int)$totalCount / (int)$pageLimit);

            if ($pageCount == 0) {
                $pageCount = 1;
            }

            $viewer->assign('PAGE_COUNT', $pageCount);
            $viewer->assign('LISTVIEW_COUNT', $totalCount);
        }

        $viewer->assign('SEARCH_DETAILS', $searchParmams);

        $currentUser = Users_Record_Model::getCurrentUserModel();
        $currentUser->set('leftpanelhide', true);
        $viewer->assign('CURRENT_CV_MODEL', ITS4YouOutgoingProducts_CustomView_Model::getInstance());
        $viewer->assign('CURRENT_USER_MODEL', $currentUser);
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $this->initializeListViewContents($request, $viewer);
        $viewer->assign('MODULE_MODEL', $moduleModel);
        $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());

        $viewer->view('ListViewContents.tpl', $moduleName);
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|string
     */
    public function preProcessTplName(Vtiger_Request $request)
    {
        return 'ListViewPreProcess.tpl';
    }

    /**
     * @param Vtiger_Request $request
     * @return bool|void
     */
    public function postProcess(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $viewer->view('ListViewPostProcess.tpl', $moduleName);
        parent::postProcess($request);
    }

    /**
     * @param Vtiger_Request $request
     * @return array
     */
    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();
        $jsFileNames = array('modules.Vtiger.resources.List', "modules.$moduleName.resources.List");
        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function getRecordsCount(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $cvId = $request->get('viewname');
        $count = $this->getListViewCount($request);
        $result = array();
        $result['module'] = $moduleName;
        $result['viewname'] = $cvId;
        $result['count'] = $count;
        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult($result);
        $response->emit();
    }

    /**
     * @param Vtiger_Request $request
     * @return mixed
     * @throws Exception
     */
    public function getListViewCount(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $searchKey = $request->get('search_key');
        $searchValue = $request->get('search_value');
        $listViewModel = new ITS4YouOutgoingProducts_ListView_Model();
        $searchParmams = $request->get('search_params');
        $listViewModel->set('search_params', Vtiger_Util_Helper::transferListSearchParamsToFilterCondition($searchParmams, $moduleModel));
        $listViewModel->set('search_key', $searchKey);
        $listViewModel->set('search_value', $searchValue);
        $listViewModel->set('operator', $request->get('operator'));
        $count = $listViewModel->getListViewCount();
        return $count;
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function getPageCount(Vtiger_Request $request)
    {
        $listViewCount = $this->getListViewCount($request);
        $pagingModel = new Vtiger_Paging_Model();
        $pageLimit = $pagingModel->getPageLimit();
        $pageCount = ceil((int)$listViewCount / (int)$pageLimit);
        if ($pageCount == 0) {
            $pageCount = 1;
        }
        $result = array();
        $result['page'] = $pageCount;
        $result['numberOfRecords'] = $listViewCount;
        $response = new Vtiger_Response();
        $response->setResult($result);
        $response->emit();
    }
}