<?php
/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Class ITS4YouOutgoingProducts_Module_Model
 */
class ITS4YouOutgoingProducts_Module_Model extends Vtiger_Module_Model
{
    public static $mobileIcon = 'inbox-arrow-up';

    /**
     * ITS4YouOutgoingProducts_Module_Model constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $headerFieldModels["productname"] = new ITS4YouOutgoingProducts_Field_Model("productname", "productname", "HEAD_PRODUCT", 2);
        $headerFieldModels["quantity"] = new ITS4YouOutgoingProducts_Field_Model("quantity", "quantity", "HEAD_QTY", 7);
        $headerFieldModels["deliverynotes_no"] = new ITS4YouOutgoingProducts_Field_Model("deliverynotes_no", "deliverynotes_no", "HEAD_DELNOTENO", 4);
        $headerFieldModels["issue_date"] = new ITS4YouOutgoingProducts_Field_Model("issue_date", "issue_date", "HEAD_DELDATE", 5);
        $headerFieldModels["parent_id"] = new ITS4YouOutgoingProducts_Field_Model("parent_id", "parent_id", "HEAD_ORGANIZATION", 10);

        $this->fields = $headerFieldModels;
    }

    /**
     * @param $fieldName
     * @return mixed
     */
    public function getField($fieldName)
    {
        return $this->fields[$fieldName];
    }


    /**
     * @param bool $blockInstance
     * @return array|bool
     */
    public function getFields($blockInstance = false)
    {
        if ($blockInstance !== false) {
            return $this->fields;
        } else {
            return array();
        }
    }


    /**
     * @return array
     */
    public function getListViewLinks()
    {
        return array();
    }


    /**
     * @param $linkParams
     * @return array
     * @throws Exception
     */
    public function getSideBarLinks($linkParams)
    {
        $linkTypes = array('SIDEBARLINK', 'SIDEBARWIDGET');
        $links = Vtiger_Link_Model::getAllByType($this->getId(), $linkTypes, $linkParams);

        $quickLinks = array(
            array(
                'linktype' => 'SIDEBARLINK',
                'linklabel' => 'LBL_RECORDS_LIST',
                'linkurl' => $this->getDefaultUrl(),
                'linkicon' => '',
            ),
        );
        foreach ($quickLinks as $quickLink) {
            $links['SIDEBARLINK'][] = Vtiger_Link_Model::getInstanceFromValues($quickLink);
        }
        return $links;
    }

    /**
     * @return string
     * @throws Exception
     */
    public function getDefaultUrl()
    {
        return 'index.php?module=' . $this->get('name') . '&view=' . $this->getListViewName();
    }

    /**
     * @return array
     */
    public function getListViewMassActions()
    {
        return [];
    }

    /**
     * @return array
     */
    public function getSettingLinks()
    {
        $settingsLinks = array();
        $currentUserModel = Users_Record_Model::getCurrentUserModel();
        $moduleName = $this->getName();

        if ($currentUserModel->isAdminUser()) {
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_UPGRADE',
                'linkurl' => 'index.php?module=ITS4YouInstaller&parent=Settings&view=Requirements&mode=Module&sourceModule=ITS4YouOutgoingProducts',
            );
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_LICENSE',
                'linkurl' => 'index.php?module=ITS4YouInstaller&view=License&parent=Settings&sourceModule=ITS4YouOutgoingProducts',
            );
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_UPGRADE',
                'linkurl' => 'index.php?module=ModuleManager&parent=Settings&view=ModuleImport&mode=importUserModuleStep1',
            );
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_UNINSTALL',
                'linkurl' => 'index.php?module=ITS4YouInstaller&view=Uninstall&parent=Settings&sourceModule=ITS4YouOutgoingProducts',
            );
        }

        return $settingsLinks;
    }

    /**
     * @return bool
     */
    public function isFilterColumnEnabled()
    {
        return false;
    }

    /**
     * @return bool
     */
    public function isStarredEnabled()
    {
        return false;
    }


    public static function getDeliveryName()
    {
        return vtlib_isModuleActive('ITS4YouWHDeliveryNotes') ? 'ITS4YouWHDeliveryNotes' : 'ITS4YouDeliveryNotes';
    }

    public function getDatabaseTables()
    {
        return [];
    }

    public function getPicklistFields()
    {
        return [];
    }
}
