<?php
/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouOutgoingProducts_ListView_Model extends Vtiger_Base_Model
{

    protected $moduleModel;

    public function __construct()
    {
        $this->moduleModel = Vtiger_Module_Model::getInstance("ITS4YouOutgoingProducts");
    }

    /**
     * Function to get the list view header
     * @return <Array> - List of Vtiger_Field_Model instances
     */
    public function getListViewHeaders()
    {
        return $this->moduleModel->getFields("DEFAULT_BLOCK");
    }

    /**
     * Function to get the list view entries
     * @param Vtiger_Paging_Model $pagingModel
     * @return array - Associative array of record id mapped to Vtiger_Record_Model instance.
     * @throws Exception
     */
    public function getListViewEntries($pagingModel)
    {
        $db = PearDatabase::getInstance();
        $moduleName = $this->moduleModel->get('name');
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }
        list($searchQuery, $params) = $this->getSearchQuery($searchParams);
        $listQuery = $this->getQuery() . $searchQuery;

        $orderBy = $this->getForSql('orderby');
        $sortOrder = $this->getForSql('sortorder');

        $startIndex = $pagingModel->getStartIndex();
        $pageLimit = $pagingModel->getPageLimit();

        if (!empty($orderBy)) {
            $listQuery .= ' ORDER BY ' . $orderBy . ' ' . $sortOrder;
        }
        $listQuery .= " LIMIT $startIndex," . ($pageLimit + 1);

        $listResult = $db->pquery($listQuery, $params);
        $listViewRecordModels = array();
        $listViewEntries = $this->getListViewRecords($listResult);

        $pagingModel->calculatePageRange($listViewEntries);

        if ($db->num_rows($listResult) > $pageLimit) {
            array_pop($listViewEntries);
            $pagingModel->set('nextPageExists', true);
        } else {
            $pagingModel->set('nextPageExists', false);
        }

        $index = 0;
        foreach ($listViewEntries as $recordId => $record) {
            $rawData = $db->query_result_rowdata($listResult, $index++);
            $record['id'] = $recordId;
            $listViewRecordModels[$recordId] = $moduleModel->getRecordFromArray($record, $rawData);
        }
        return $listViewRecordModels;
    }

    /**
     * @param $searchParams
     * @return array
     */
    private function getSearchQuery($searchParams)
    {
        $searchQuery = "";
        $params = array();
        if (isset($searchParams[0]["columns"])) {
            $subSearchParams = $searchParams[0]["columns"];
            foreach ($subSearchParams as $searchParamsArr) {
                $condition = isset($searchParamsArr["column_condition"]) ? $searchParamsArr["column_condition"] : "";
                switch ($searchParamsArr["columnname"]) {
                    case "issue_date":
                        $searchQuery .= $searchParamsArr["columnname"] . " BETWEEN ? AND ? " . $condition . " ";
                        list($date_start, $date_end) = explode(",", $searchParamsArr["value"]);
                        $params = array_merge($params, array(DateTimeField::convertToDBFormat($date_start), DateTimeField::convertToDBFormat($date_end)));
                        break;

                    case "quantity":
                        $searchQuery .= $searchParamsArr["columnname"] . " = ? " . $condition . " ";
                        array_push($params, $searchParamsArr["value"]);
                        break;

                    case 'parent_id':
                        $searchQuery .= ' vtiger_account.accountname LIKE ? ' . $condition . ' ';
                        array_push($params, '%' . $searchParamsArr["value"] . '%');
                        break;

                    default:
                        $searchQuery .= $searchParamsArr["columnname"] . " LIKE ? " . $condition . " ";
                        array_push($params, "%" . $searchParamsArr["value"] . "%");
                        break;
                }
            }
        }
        if ($searchQuery != "") {
            $searchQuery = " AND " . $searchQuery;
        }

        return array($searchQuery, $params);
    }

    private function getQuery()
    {
        $query = "SELECT  
                    CONCAT_WS('_',vtiger_inventoryproductrel.productid, vtiger_inventoryproductrel.id, vtiger_inventoryproductrel.sequence_no) AS uniqueid,
                    vtiger_products.productname,
                    vtiger_inventoryproductrel.productid,
                    vtiger_inventoryproductrel.id,
                    vtiger_inventoryproductrel.sequence_no,
                    vtiger_inventoryproductrel.quantity,                                             
                    vtiger_crmentity.setype,
                    'Products' AS entitytype,                     
                    its4you_deliverynotes.deliverynotes_no,
                    its4you_deliverynotes.issue_date,
                    its4you_deliverynotes.parent_id,
                    vtiger_account.accountname                    
                FROM vtiger_inventoryproductrel                 
                LEFT JOIN its4you_deliverynotes
                        ON its4you_deliverynotes.deliverynoteid=vtiger_inventoryproductrel.id
                INNER JOIN vtiger_crmentity
                        ON vtiger_crmentity.crmid=vtiger_inventoryproductrel.id 
                LEFT JOIN vtiger_users 
                        ON vtiger_users.id = vtiger_crmentity.smownerid
                LEFT JOIN vtiger_groups 
                        ON vtiger_groups.groupid = vtiger_crmentity.smownerid            
                INNER JOIN vtiger_products 
                       ON vtiger_products.productid=vtiger_inventoryproductrel.productid                 
                LEFT JOIN vtiger_account
                       ON vtiger_account.accountid=its4you_deliverynotes.parent_id                 
                WHERE its4you_deliverynotes.deliverynotestatus = 'Ready to Deliver' 
                  AND vtiger_crmentity.deleted = 0
                  AND " . $this->getListViewSecurityParameter(ITS4YouOutgoingProducts_Module_Model::getDeliveryName());

        return $query;
    }

    private function getListViewSecurityParameter($module)
    {
        global $current_user;
        require 'user_privileges/user_privileges_' . $current_user->id . '.php';
        require 'user_privileges/sharing_privileges_' . $current_user->id . '.php';

        $tabid = getTabid($module);
        $sec_query = " (vtiger_crmentity.setype = '" . $module . "'";
        if ($is_admin == false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 && $defaultOrgSharingPermission[$tabid] == 3) {
            $sec_query .= " AND 
                        (vtiger_crmentity.smownerid IN (" . $current_user->id . " )
                            OR vtiger_crmentity.smownerid IN
                             (
                                 SELECT vtiger_user2role.userid FROM vtiger_user2role
                                 INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid
                                 INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid
                                 WHERE vtiger_role.parentrole LIKE '" . $current_user_parent_role_seq . "::%'
                             )
                             OR vtiger_crmentity.smownerid IN
                             (
                                 SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per
                                 WHERE userid=" . $current_user->id . " AND tabid=" . $tabid . "
                             )
                             OR
                             (";

            // Build the query based on the group association of current user.
            if (sizeof($current_user_groups) > 0) {
                $sec_query .= " vtiger_groups.groupid IN (" . implode(",", $current_user_groups) . ") OR ";
            }
            $sec_query .= " vtiger_groups.groupid IN
						(
                                                    SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid
                                                    FROM vtiger_tmp_read_group_sharing_per
                                                    WHERE userid=" . $current_user->id . " and tabid=" . $tabid . "
						)";
            $sec_query .= ")
                    )";
        }
        $sec_query .= ")";

        return $sec_query;
    }

    /**
     * @param $_dbResult
     * @return array
     */
    private function getListViewRecords($_dbResult)
    {
        $db = PearDatabase::getInstance();
        $listViewEntries = array();

        while ($row = $db->fetchByAssoc($_dbResult)) {
            foreach ($row as $key => $val) {
                $tmpVal = $val;

                if ('issue_date' === $key) {
                    $tmpVal = DateTimeField::convertToUserFormat($val);
                }

                if ('parent_id' === $key && !empty($val) && isRecordExists($val)) {
                    $record = Vtiger_Record_Model::getInstanceById($val);

                    if ($record) {
                        $tmpVal = $record->getName();
                    }
                }

                $listViewEntries[$row['uniqueid']][$key] = $tmpVal;
            }
        }

        return $listViewEntries;
    }

    /**
     * @return int
     * @throws Exception
     */
    public function getListViewCount()
    {
        $db = PearDatabase::getInstance();

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }

        list($searchQuery, $params) = $this->getSearchQuery($searchParams);
        $listQuery = $this->getQuery() . $searchQuery;

        $position = stripos($listQuery, 'FROM');
        if ($position) {
            $split = explode('FROM', $listQuery);
            unset($split[0]);

            $listQuery = 'SELECT count(*) AS count FROM ' . implode('FROM', $split);
        }

        $listResult = $db->pquery($listQuery, $params);
        return $db->query_result($listResult, 0, 'count');
    }

}
